<?php

namespace Modules\Product\app\Http\Controllers\Dashboard\Frest;

use Illuminate\Http\Request;
use Illuminate\Routing\Controller;
use Modules\Product\app\Models\Product;
use Illuminate\Contracts\Support\Renderable;
use Modules\Product\app\Models\Guarantee;
use Modules\Product\app\Models\ProductGuarantee;
use Modules\Product\app\Http\Requests\GuaranteeStoreRequest;

class ProductGuaranteeController extends Controller
{
    public function index(Product $product)
    {
        $guarantees = $product->guarantees;
        return view('product::Dashboard.Frest.guarantee.index' , compact('guarantees' , 'product'));
    }

    /**
     * Show the form for creating a new resource.
     * @return Renderable
     */
    public function create(Product $product)
    {
        $guarantees = Guarantee::latest()->get();

        return view('product::Dashboard.Frest.guarantee.create' , compact('product' , 'guarantees'));
    }

    /**
     * Store a newly created resource in storage.
     * @param Request $request
     * @return Renderable
     */
    public function store(GuaranteeStoreRequest $request , Product $product)
    {

        // $this->authorize('product.create');
        $guarantee = Guarantee::firstOrCreate(['name' => $request->name ] ,
        [
            'name' =>$request->name,
            'status' >(int)$request->status,
        ]);




        ProductGuarantee::create([
            'guarantee_id' => $guarantee->id,
            'product_id' => $product->id,
            'price_increase' => $request->price_increase,
            'status' => (int)$request->status,
            'default' => (int)$request->default,
        ]);

        return redirect()->route('admin.product-guarantees' , $product);

    }



    /**
     * Show the form for editing the specified resource.
     * @param int $id
     * @return Renderable
     */
    public function edit(ProductGuarantee $productGuarantee)
    {
        $guarantees = Guarantee::latest()->get();

        return view('product::Dashboard.Frest.guarantee.edit' , compact('productGuarantee' , 'guarantees'));
    }

    /**
     * Update the specified resource in storage.
     * @param Request $request
     * @param int $id
     * @return Renderable
     */
    public function update(GuaranteeStoreRequest $request, ProductGuarantee $productGuarantee)
    {

        $guarantee = Guarantee::firstOrCreate(['name' => $request->name] ,
        [
            'name' =>$request->name,
            'status' >(int)$request->state,

        ]);




        $productGuarantee->update([
            'guarantee_id' => $guarantee->id,
            'price_increase' => $request->price_increase,
            'status' => (int)$request->status,
            'default' => (int)$request->default,
        ]);
        return redirect()->route('admin.product-guarantees' , $productGuarantee->product_id);
    }

    /**
     * Remove the specified resource from storage.
     * @param int $id
     * @return Renderable
     */
    public function destroy(ProductGuarantee $productGuarantee)
    {
        $productGuarantee->delete();
        return redirect()->back();
    }
}
