<?php

namespace Modules\Product\app\Http\Controllers\Dashboard\Frest;

use Illuminate\Http\Request;
use Illuminate\Routing\Controller;
use Modules\Product\app\Models\Product;
use Illuminate\Contracts\Support\Renderable;
use Modules\Product\app\Models\Material;
use Modules\Product\app\Models\ProductMaterial;
use Modules\Product\app\Http\Requests\MaterialStoreRequest;

class ProductMaterialController extends Controller
{
    public function index(Product $product)
    {
        $materials = $product->materials;
        return view('product::Dashboard.Frest.material.index' , compact('materials' , 'product'));
    }


    public function create(Product $product)
    {
        $materials = Material::latest()->get();

        return view('product::Dashboard.Frest.material.create' , compact('product' , 'materials'));
    }


    public function store(MaterialStoreRequest $request , Product $product)
    {

        // $this->authorize('product.create');
        $material = Material::firstOrCreate(['material_name' => $request->name , 'type' => $request->type ] ,
        [
            'material_name' =>$request->name,
            'type' =>$request->type,
            'state' >(int)$request->status,
        ]);


        ProductMaterial::create([

            'material_id' => $material->id,
            'product_id' => $product->id,
            'price_increase' => $request->price_increase,
            'status' => (int)$request->status,
            'default' => (int)$request->default,
        ]);

        return redirect()->route('admin.product-materials' , $product);

    }




    public function edit(ProductMaterial $productMaterial)
    {
        $materials = Material::latest()->get();

        return view('product::Dashboard.Frest.material.edit' , compact('productMaterial' , 'materials'));
    }


    public function update(MaterialStoreRequest $request, ProductMaterial $productMaterial)
    {

        $material = Material::firstOrCreate(['material_name' => $request->name , 'type' => $request->type ] ,
        [
            'material_name' =>$request->name,
            'type' =>$request->type,
            'state' >(int)$request->status,
        ]);



        $productMaterial->update([
            'material_id' => $material->id,
            'price_increase' => $request->price_increase,
            'status' => (int)$request->status,
            'default' => (int)$request->default,
        ]);
        return redirect()->route('admin.product-materials' , $productMaterial->product_id);
    }

    /**
     * Remove the specified resource from storage.
     * @param int $id
     * @return Renderable
     */
    public function destroy(ProductMaterial $productMaterial)
    {
        $productMaterial->delete();
        return redirect()->back();
    }
}
