<?php

namespace Modules\Product\app\Models;


use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;
use Modules\Category\app\Models\Category;
use Modules\Comment\app\Models\Comment;
use Modules\Core\app\Http\Controllers\Helpers\Str;
use Modules\Field\app\Models\FieldModel;
use Modules\File\app\Models\File;
use Modules\Invoice\app\Models\InvoiceItem;
use Modules\Language\app\Models\Language;
use Modules\Service\app\Models\ServiceModel;
use Modules\Tag\app\Models\Tag;

class Product extends Model
{
    use SoftDeletes;

    protected $fillable = [
        'title',
        'slug',
        'body',
        'image',
        'link',
        'state',
        'view_count',
        'comment_count',
        'publish_up',
        'publish_down',
        'main_cat',
        'discount',
        'price',
        'color_image',
        'material_image',
        'tran_id',
        'lang',
        'type',
        'lead'
    ];


    public function scopeActive($query)
    {
        $date = date('Y-m-d H:i:s');
        return $query->where('state',1)
            ->where(function($q) use ($date) {
                $q->whereRaw('publish_up IS NULL OR publish_up < ?', [$date]);
            })
            ->where(function($q) use ($date) {
                $q ->whereRaw('publish_down IS NULL OR publish_down > ?', [$date]);
            });
    }

    public function services()
    {
        return $this->morphMany(ServiceModel::class, 'services','model_type','model_id');
    }
    public function translates(){
        return $this->hasMany(Product::class,'tran_id','id');
    }
    public function language(){
        return $this->belongsTo(Language::class,'lang','name');
    }

    public function category()
    {
        return $this->belongsTo(Category::class, 'main_cat');
    }


    public function comments()
    {
        return $this->morphMany(Comment::class, 'comment','commentable_type','commentable_id');
    }

    public function commentsActive()
    {
        return $this->morphMany(Comment::class, 'comment','commentable_type','commentable_id')->where('state','=',1);
    }

    public function categories()
    {
        return $this->morphToMany(Category::class, 'catgable');
    }

    public function fields()
    {
        return $this->morphMany(FieldModel::class, 'fieldModel','model_type','model_id');
    }
    public function files()
    {
        return $this->morphMany(File::class, 'filable','file_type','file_id');
    }

    public function galleries()
    {
        return $this->morphMany(File::class, 'filable','file_type','file_id')->where('type','galleries');
    }

    public function tags()
    {
        return $this->morphToMany(Tag::class, 'taggable');
    }
    public function guarantees()
    {
        return $this->hasMany(ProductGuarantee::class);
    }
    public function colors()
    {
        return $this->hasMany(ProductColor::class);
    }
    public function materials()
    {
        return $this->hasMany(ProductMaterial::class);
    }

    public function invoiceItem() {
        return $this->morphMany(InvoiceItem::class, 'item','item_type','item_id');
    }

    public function getImageAttribute($value){
        return $value;
    }


    public function getRouteAttribute()
    {
        $lang = config('app.multi_lang') == true ? true : false;

        return $lang != true ? "/show/products/{$this->id}/{$this->slug}" : "/$this->lang/show/products/{$this->id}/{$this->slug}";
    }

    public function cart(): MorphMany
    {
        return $this->morphMany(Cart::class , 'cartable');
    }
}

