<?php

namespace Modules\Product\app\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Factories\HasFactory;


class ProductColor extends Model
{

    use HasFactory;

    protected $table = 'products_colors';
    protected $fillable = [
        'product_id',
        'color_id',
        'image',
        'price_increase',
        'default',
        'status',
        'sold_number',
        'frozen_number',
        'marketable_number',
    ];


    public function product()
    {
        return $this->belongsTo(Product::class);
    }
    public function color()
    {
        return $this->belongsTo(Color::class);
    }
}
