<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('products', function (Blueprint $table) {
            $table->id();
            $table->string('title');
            $table->text('body')->nullable();
            $table->string('image')->nullable();
            $table->string('link')->nullable();
            $table->boolean('state')->default(0);

            $table->integer('view_count')->default(0);
            $table->integer('comment_count')->default(0);

            $table->timestamp('publish_up')->nullable();
            $table->timestamp('publish_down')->nullable();

            $table->unsignedBigInteger('main_cat')->nullable();
            $table->foreign('main_cat')->references('id')->on('categories')->onDelete('set null');

            $table->softDeletes();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('products');
    }
};
