@extends('core::Dashboard.Frest.Layouts.master')

@section('title')
    داشبورد
@endsection




@section('content')
    <div class="row">
        <div class="col">
            <h6 class="mt-4 secondary-font">ایجاد</h6>
            <div class="card mb-3">
                <div class="card-header border-bottom primary-font">
                    <ul class="nav nav-tabs card-header-tabs" role="tablist">
                        <li class="nav-item">
                            <button class="nav-link active" data-bs-toggle="tab" data-bs-target="#tab1" role="tab"
                                aria-selected="true">
                                اطلاعات
                            </button>
                        </li>
                    </ul>
                </div>

                <div class="tab-content">
                    <form id="formData" action="{{ route('admin.product-colors.store', $product) }}" method="post">
                        {{ csrf_field() }}

                        <div class="tab-pane fade active show" id="tab1" role="tabpanel">


                            <div class="row g-3">

                                <div class="col-md-8 offset-2">

                                    <div class="row">


                                        <div class="col-md-6">
                                            <span>*</span>
                                            <label class="form-label" for="title">عنوان</label>


                                            <input type="text" list="colors" id="colorName" name="colorName"
                                                class="form-control custom-select custom-select-sm" placeholder="عنوان">
                                            <datalist id="colors">
                                                @foreach ($colors as $color)
                                                    <option value="{{ $color->color_name }}">
                                                @endforeach
                                            </datalist>
                                            @if ($errors->has('colorName'))
                                                <div data-field="colorName" class="text-danger">
                                                    {{ $errors->first('colorName') }}
                                                </div>
                                            @endif
                                        </div>




                                        <div class="col-md-2">
                                            <span>*</span>
                                            <label class="form-label" for="state">وضعیت</label>
                                            <div class="position-relative">
                                                <select required id="status" name="status" class="form-select">
                                                    <option value="1" {{ '1' == old('status') ? 'selected' : '' }}>فعال
                                                    </option>
                                                    <option value="0" {{ '0' == old('status') ? 'selected' : '' }}>غیر
                                                        فعال</option>
                                                </select>
                                            </div>
                                        </div>
                                        <div class="col-md-2">
                                            <span>*</span>
                                            <label class="form-label" for="state">نوع</label>
                                            <div class="position-relative">
                                                <select required id="type" name="type" class="form-select">
                                                    <option value="body" {{ '1' == old('type') ? 'selected' : '' }}>پارچه
                                                    </option>
                                                    <option value="woods" {{ '0' == old('type') ? 'selected' : '' }}>چوب
                                                    </option>
                                                </select>
                                            </div>
                                        </div>

                                        <div class="col-md-2">
                                            <span>*</span>
                                            <label class="form-label" for="state">پیش فرض</label>
                                            <div class="position-relative">
                                                <select required id="status" name="default" class="form-select">
                                                    <option value="1" {{ '1' == old('default') ? 'selected' : '' }}>
                                                        باشد
                                                    </option>
                                                    <option value="0" {{ '0' == old('default') ? 'selected' : '' }}>
                                                        نباشد
                                                    </option>
                                                </select>
                                            </div>
                                        </div>

                                        <div class="col-md-4">
                                            <label class="form-label" for="title">تصویر رنگ محصول</label>
                                            <div class="input-group">
                                                <input type="text" id="image1" class="form-control" name="image"
                                                       aria-label="Image" aria-describedby="button-image">
                                                <div class="input-group-append">
                                                    <button class="btn btn-outline-secondary" type="button" id="button-image">آپلود</button>
                                                </div>
                                            </div>
                                        </div>




                                        <div class="col-md-8">
                                            <span>*</span>
                                            <label class="form-label" for="link">افزایش قیمت</label>
                                            <div class="input-group">
                                                <input type="text" name="price_increase" value="{{ old('price_increase') }}"
                                                       class="form-control custom-select custom-select-sm">
                                                @if ($errors->has('price_increase'))
                                                    <div data-field="price_increase" class="text-danger">
                                                        {{ $errors->first('price_increase') }}
                                                    </div>
                                                @endif
                                            </div>

                                        </div>






                                    </div>

                                </div>





                            </div>


                        </div>

                        <div class="pt-4">
                            <button type="submit" name="save" class="btn btn-primary me-sm-3 me-1">ثبت</button>
                            <a href="{{ route('admin.product-colors', $product) }}" type="reset"
                                class="btn btn-label-secondary">انصراف</a>
                        </div>

                    </form>
                </div>
            </div>
        </div>
    </div>
@endsection
