@extends('core::Dashboard.Frest.Layouts.master')

@section('title')
    داشبورد
@endsection

@section('style')
@endsection

@section('script')
@endsection

@section('content')
    <div class="card">
        <div class="mt-3">
            <a  class="btn btn-info px-2" href="{{ route('admin.product-guarantees.create', $product) }}">
            ایجاد گارانتی جدید
            </a>
        </div>
        <h5 class="card-header">
            گارانتی محصول</h5>
        <div class="table-responsive text-nowrap">
            <table class="table table-sm">
                <thead>
                    <tr>
                        <th>
                            <div class="bulk-ids checkbox-primary m-r-15">
                                <input id="bulk-ids" onClick="toggle(this)" type="checkbox">
                                <label for="bulk-ids">#</label>
                            </div>
                        </th>
                        <th>عنوان</th>
                        <th>افزایش قیمت</th>
                        <th>وضعیت</th>
                        <th>عملیات</th>
                    </tr>
                </thead>
                <tbody>

                    @foreach ($guarantees as $guarantee)
                        <tr>
                            <th>
                                {{ $guarantee->id }}
                            </th>
                            <th>
                                {{ $guarantee->guarantee->name }}
                            </th>
                            <th>
                                {{ number_format($guarantee->price_increase) }}
                            </th>

                            <td>
                                {{ $guarantee->status == 1 ? 'فعال' : 'غیر فعال' }}
                            </td>



                            <td>
                                <div class="dropdown">
                                    <button type="button" class="btn p-0 dropdown-toggle hide-arrow"
                                        data-bs-toggle="dropdown"><i class="bx bx-dots-vertical-rounded"></i></button>
                                    <div class="dropdown-menu">
                                        <a class="dropdown-item" href="{{ route('admin.product-guarantees.edit', $guarantee) }}"><i
                                                class="bx bx-edit-alt me-1"></i>ویرایش</a>

                                        <button class="dropdown-item"
                                            onclick="event.preventDefault();confirmDelete('delete-{{ $guarantee->id }}')"><i
                                                class="bx bx-trash me-1"></i>حذف</button>
                                        <form id="delete-{{ $guarantee->id }}"
                                            action="{{ route('admin.product-guarantees.destroy', $guarantee) }}" method="POST"
                                            style="display: none;">
                                            {{ csrf_field() }}
                                            {{ method_field('DELETE') }}
                                        </form>
                                    </div>
                                </div>
                            </td>
                        </tr>
                    @endforeach

                </tbody>
            </table>

            {{-- <div style="margin-top: 10%;">
                {{ $colors->render() }}
            </div> --}}
        </div>





    </div>
@endsection
