@extends('core::Dashboard.Frest.Layouts.master')

@section('title')
    داشبورد
@endsection



n

@section('content')
    <div class="row">
        <div class="col">
            <h6 class="mt-4 secondary-font">ویرایش</h6>
            <div class="card mb-3">
                <div class="card-header border-bottom primary-font">
                    <ul class="nav nav-tabs card-header-tabs" role="tablist">
                        <li class="nav-item">
                            <button class="nav-link active" data-bs-toggle="tab" data-bs-target="#tab1" role="tab"
                                aria-selected="true">
                                اطلاعات
                            </button>
                        </li>
                    </ul>
                </div>

                <div class="tab-content">
                    <form id="formData" action="{{ route('admin.product-materials.update', $productMaterial) }}" method="post">
                        {{ csrf_field() }}
                        @method('put')
                        <div class="tab-pane fade active show" id="tab1" role="tabpanel">


                            <div class="row g-3">
                                <div class="col-md-8 offset-2">

                                    <div class="row">


                                        <div class="col-md-6">
                                            <span>*</span>
                                            <label class="form-label" for="title">عنوان</label>


                                            <input type="text" list="colors" id="colorName" name="name"
                                                class="form-control " placeholder="عنوان"  value="{{ $productMaterial->material->material_name  }}">
                                            <datalist id="colors">
                                                @foreach ($materials as $material)
                                                    <option value="{{ $material->material_name }}">
                                                @endforeach
                                            </datalist>
                                            @if ($errors->has('name'))
                                                <div data-field="name" class="text-danger">
                                                    {{ $errors->first('name') }}
                                                </div>
                                            @endif
                                        </div>






                                        <div class="col-md-2">
                                            <span>*</span>
                                            <label class="form-label" for="state">وضعیت</label>
                                            <div class="position-relative">
                                                <select required id="status" name="status" class="form-select">
                                                    <option value="1" {{ '1' == $productMaterial->status ? 'selected' : '' }}>فعال
                                                    </option>
                                                    <option value="0" {{ '0' == $productMaterial->status ? 'selected' : '' }}>غیر
                                                        فعال</option>
                                                </select>
                                            </div>
                                        </div>








                                        <div class="col-md-2">
                                            <span>*</span>
                                            <label class="form-label" for="state">پیش فرض</label>
                                            <div class="position-relative">
                                                <select required id="status" name="default" class="form-select">
                                                    <option value="1" {{ '1' == $productMaterial->default  ? 'selected' : '' }}>
                                                        باشد
                                                    </option>
                                                    <option value="0" {{ '0' == $productMaterial->default  ? 'selected' : '' }}>
                                                        نباشد
                                                    </option>
                                                </select>
                                            </div>
                                        </div>



                                        <div class="col-md-8">
                                            <span>*</span>
                                            <label class="form-label" for="link">افزایش قیمت</label>

                                            <div class="input-group">
                                                <input type="text" name="price_increase" value="{{ $productMaterial->price_increase }}"
                                                       class="form-control ">
                                                @if ($errors->has('price_increase'))
                                                    <div data-field="price_increase" class="text-danger">
                                                        {{ $errors->first('price_increase') }}
                                                    </div>
                                                @endif
                                            </div>

                                        </div>
                                        <div class="col-md-2">
                                            <span>*</span>
                                            <label class="form-label" for="state">نوع</label>
                                            <div class="position-relative">
                                                <select required id="type" name="type" class="form-select">
                                                    <option value="body" {{ 'body' == $productMaterial->woods ? 'selected' : '' }}>پارچه
                                                    </option>
                                                    <option value="woods" {{ 'woods' == $productMaterial->body ? 'selected' : '' }}>چوب
                                                    </option>
                                                </select>
                                            </div>
                                        </div>


                                    </div>

                                </div>
                            </div>


                        </div>

                        <div class="pt-4">
                            <button type="submit" name="save" class="btn btn-primary me-sm-3 me-1">ثبت</button>

                        </div>

                    </form>
                </div>
            </div>
        </div>
    </div>

@endsection
