@extends('core::Dashboard.Frest.Layouts.master')

@section('title')داشبورد@endsection

    @section('style')
        <link rel="stylesheet" href="{{asset('modules/core/vendor/libs/tagify/tagify.css')}}" />
        @endsection

    @section('script')


        <script src="{{asset('modules/core/editors/ckeditor/ckeditor.js')}}"></script>

        <script src="{{asset('modules/core/vendor/libs/tagify/tagify.js')}}"></script>

        <script>
            var options = {
                 filebrowserImageBrowseUrl: '/file-manager/ckeditor',
            };
            CKEDITOR.replace('body' ,options);
            $('#submit').on('keyup keypress', function(e) {
                var keyCode = e.keyCode || e.which;
                if (keyCode === 13) {
                    e.preventDefault();
                    return false;
                }
            });
        </script>

        <script>

            const tag1 = document.querySelector("#tag");
            const tag = new Tagify(tag1, {
                whitelist: [{!!  \Modules\Core\app\Http\Controllers\Helpers\Str::implodeArray($tags->pluck('name')->toArray()) !!}],
                dropdown: {
                    classname: "tags-look", // <- custom classname for this dropdown, so it could be targeted
                    enabled: 0,             // <- show suggestions on focus
                    closeOnSelect: false    // <- do not hide the suggestions dropdown once an item has been selected
                }
            });
        </script>

    @endsection

@section('content')

    @include('core::components.file_set_to_editor')

    <div class="row">
        <div class="col">
            <h6 class="mt-4 secondary-font">ویرایش</h6>
            <div class="card mb-3">
                <div class="card-header border-bottom primary-font">
                    <ul class="nav nav-tabs card-header-tabs" role="tablist">
                        <li class="nav-item">
                            <button class="nav-link active" data-bs-toggle="tab" data-bs-target="#tab1" role="tab" aria-selected="true">
                               اطلاعات
                            </button>
                        </li>
                        <li class="nav-item">
                            <button class="nav-link" data-bs-toggle="tab" data-bs-target="#publish" role="tab" aria-selected="true">
                                انتشار
                            </button>
                        </li>
                        <li class="nav-item">
                            <button class="nav-link" data-bs-toggle="tab" data-bs-target="#gallery" role="tab" aria-selected="true">
                                گالری
                            </button>
                        </li>
                        @foreach($field_groups->where('type','products') as $group)

                            <li class="nav-item">
                                <button class="nav-link" data-bs-toggle="tab" data-bs-target="#{{$group->name}}" role="tab" aria-selected="true">
                                    {{$group->title}}
                                </button>
                            </li>


                        @endforeach
                    </ul>
                </div>

                <div class="tab-content">
                    <form id="formData" action="{{route('admin.product.update',$product->id)}}" method="post">
                        {{ csrf_field() }}
                        @method('patch')
                        <div class="tab-pane fade active show" id="tab1" role="tabpanel">


                            <div class="row g-3">

                                <div class="col-md-12">

                                    <div class="row">

                                        <div class="col-md-6 ">
                                            <span>*</span>
                                            <label class="form-label" for="title">عنوان</label>
                                            <input type="text" id="title"  name="title" class="form-control" placeholder="عنوان" value="{{$product->title}}">
                                            @if($errors->has('title'))
                                                <div data-field="title" class="text-danger">{{ $errors->first('title') }}</div>
                                            @endif
                                        </div>

                                        <div class="col-md-6 ">
                                            <span>*</span>
                                            <label class="form-label" for="slug">اسلاگ</label>
                                            <input type="text" id="slug"  name="slug" class="form-control" placeholder="اسلاگ" value="{{$product->slug}}">
                                            @if($errors->has('slug'))
                                                <div data-field="slug" class="text-danger">{{ $errors->first('slug') }}</div>
                                            @endif
                                        </div>



                                        <div class="col-md-6">
                                            <span>*</span>
                                            <label class="form-label" for="link">قیمت</label>
                                            <input type="text" id="price" name="price" class="form-control"
                                                placeholder="قیمت" value="{{$product->price}}">
                                            @if ($errors->has('price'))
                                                <div data-field="price" class="text-danger">{{ $errors->first('price') }}
                                                </div>
                                            @endif
                                        </div>

                                        <div class="col-md-6">
                                            <span>*</span>
                                            <label class="form-label" for="link">تخفیف</label>
                                            <input type="number" min="0" max="100" id="price" name="discount" class="form-control"
                                                   placeholder="تخفیف" value="{{$product->discount}}">
                                            @if ($errors->has('discount'))
                                                <div data-field="discount" class="text-danger">{{ $errors->first('discount') }}
                                                </div>
                                            @endif 
                                        </div>




                                        <div class="col-md-2">
                                            <span>*</span>
                                            <label class="form-label" for="state">نوع </label>
                                            <div class="position-relative">
                                                <select id="type" name="type" class="form-select">
                                                    <option value="products" {{ 'products' == $product->type ? 'selected' : '' }}>محصولات</option>
                                                    <option value="courses" {{ 'courses' == $product->type ? 'selected' : '' }}>دوره ها</option>
                                                    <option value="business" {{ 'business' == $product->type ? 'selected' : '' }}>کسب و کارها</option>
                                                </select>
                                            </div>
                                        </div>

                                        <div class="col-md-4 ">
                                            <span>*</span>
                                            <label class="form-label" for="state">وضعیت</label>
                                            <div class="position-relative">
                                                <select id="state" name="state" class="form-select" >
                                                    <option value="1" {{'1' == $product->state ? 'selected' : ''}}>فعال</option>
                                                    <option value="0" {{'0' == $product->state ? 'selected' : ''}}>غیر فعال</option>
                                                </select>
                                            </div>
                                        </div>

                                        <div class="col-md-6">
                                            <label class="form-label" for="title">تصویر محصول</label>
                                            <div class="input-group">
                                                <input type="text" id="image-2" class="form-control" name="image"
                                                       aria-label="Image" aria-describedby="button-image-2">
                                                <div class="input-group-append">
                                                    <button class="btn btn-outline-secondary" type="button" id="button-image-2">آپلود</button>
                                                </div>
                                            </div>
                                        </div>


                                        <div class="col-md-12">
                                            <label class="form-label" for="desc">توضیحات کوتاه</label>
                                            <textarea type="text" id="lead"  name="lead" class="form-control" >{{old('lead',$product->lead)}}</textarea>
                                            @if($errors->has('lead'))
                                                <div data-field="lead" class="text-danger">{{ $errors->first('lead') }}</div>
                                            @endif
                                        </div>



                                        <div class="col-md-12">
                                            <label class="form-label" for="desc">متن کامل</label>
                                            <textarea  type="text" id="body"  name="body" class="form-control" >{{$product->body}}</textarea>
                                            @if($errors->has('body'))
                                                <div data-field="desc" class="text-danger">{{ $errors->first('body') }}</div>
                                            @endif

                                            <br>
                                            <button type="button"  data-bs-toggle="modal" data-bs-target="#create-file-editor" class="btn btn-primary me-1">درج ویدیو و صوت در ادیتور</button>

                                        </div>



                                    </div>

                                </div>





                            </div>


                          </div>
                        <div class="tab-pane fade " id="tab2" role="tabpanel">
                            <div class="row g-3">

                                <div class="col-md-6">

                                    <div class="row">



                                    </div>

                                </div>

                                <div class="col-md-6">

                                    <div class="row">





                                    </div>

                                </div>

                            </div>
                        </div>
                        <div class="tab-pane fade " id="publish" role="tabpanel">


                            <div class="row g-3">

                                <div class="col-md-5">

                                    <div class="row">

                                        <div class="col-md-12">
                                            <span>*</span>
                                            <label class="form-label" for="state">زبان</label>
                                            <div class="position-relative">
                                                <select id="lang" name="lang" class="form-select" >
                                                    @foreach($languages as $language)
                                                        @if(!in_array($language->name,$trans) || $language->name == $product->lang)
                                                            <option value="{{$language->name}}" {{$language->name == $product->lang ? 'selected' : ''}}>
                                                                {{$language->title}}</option>
                                                        @endif
                                                    @endforeach
                                                </select>
                                            </div>
                                        </div>

                                        <div class="col-12 mb-10">
                                            <label for="selectpickerSelectDeselect" class="form-label">دسته بندی اصلی</label>
                                            <select id="selectpickerSelectDeselect" name="main_cat" class="selectpicker w-100" data-style="btn-default" data-actions-box="true" data-live-search="true">
                                                @foreach($categories as $category)
                                                    @include('category::Dashboard.Frest.category.listCategoryShow',['row' => 0,'category' => $category,'cat_id' => $product->main_cat])
                                                @endforeach
                                            </select>
                                        </div>


                                        <div class="col-12 mb-10">
                                            <label for="selectpickerSelectDeselect" class="form-label">دسته بندی فرعی</label>
                                            <select id="selectpickerSelectDeselect" name="categories[]" class="selectpicker w-100" data-style="btn-default" multiple data-actions-box="true" data-live-search="true">
                                                @foreach($categories as $category)
                                                    @include('category::Dashboard.Frest.category.listCategoryShow',['row' => 0,'category' => $category,'model' => $product])
                                                @endforeach
                                            </select>
                                        </div>

                                        <div class="col-12 mb-10">
                                            <label for="selectpickerSelectDeselect" class="form-label">سرویس های نمایشی</label>
                                            <select id="selectpickerSelectDeselect" name="service_ids[]" class="selectpicker w-100" data-style="btn-default" multiple data-actions-box="true" data-live-search="true">
                                                @foreach($services as $service)
                                                    <option value="{{$service->id}}" {{in_array($service->id,$product->services->pluck('service_id')->toArray()) ? 'selected' : ''}}>{{$service->title}}</option>
                                                @endforeach
                                            </select>
                                        </div>

                                        <div class="col-md-12">
                                                <label for="flatpickr-datetime" class="form-label">تاریخ و ساعت  شروع انتشار</label>
                                                <input type="text" class="form-control" placeholder="YYYY-MM-DD HH:MM" name="publish_up" id="publish_up"  value="{{\Modules\Core\app\Http\Controllers\Helpers\Str::convertToJalali($product->publish_up)}}" />
                                        </div>

                                        <div class="col-md-12">
                                            <label for="flatpickr-datetime" class="form-label">تاریخ و ساعت پایان انتشار</label>
                                            <input type="text" class="form-control" placeholder="YYYY-MM-DD HH:MM" name="publish_down" id="publish_down" value="{{\Modules\Core\app\Http\Controllers\Helpers\Str::convertToJalali($product->publish_down)}}" />
                                        </div>

                                    </div>

                                </div>


                                <div class="col-md-6">

                                    <div class="row">

                                        <div class="col-md-12">
                                            <span>*</span>
                                            <label class="form-label" for="link">لینک</label>
                                            <input type="text" id="link"  name="link" class="form-control" placeholder="لینک" value="{{$product->link}}">
                                            @if($errors->has('link'))
                                                <div data-field="link" class="text-danger">{{ $errors->first('link') }}</div>
                                            @endif
                                        </div>

                                        <div class="col-md-12">
                                            <label class="form-label" for="title"> کاتالوگ رنگ</label>
                                            <div class="input-group">
                                                <input type="text" id="image-3" class="form-control" name="color_image"
                                                       aria-label="Image" aria-describedby="button-image-3">
                                                <div class="input-group-append">
                                                    <button class="btn btn-outline-secondary" type="button" id="button-image-3">آپلود</button>
                                                </div>
                                            </div>
                                        </div>


                                        <div class="col-md-12">
                                            <label class="form-label" for="title"> کاتالوگ جنس</label>
                                            <div class="input-group">
                                                <input type="text" id="image-4" class="form-control" name="material_image"
                                                       aria-label="Image" aria-describedby="button-image-4">
                                                <div class="input-group-append">
                                                    <button class="btn btn-outline-secondary" type="button" id="button-image-4">آپلود</button>
                                                </div>
                                            </div>
                                        </div>

                                        <div class="col-md-12">
                                            <label for="tag" class="form-label">تگ</label>
                                            <input id="tag" class="form-control" name="tag" value='{!!  implode(', ',$product->tags->pluck('name')->toArray()) !!}' />
                                        </div>

                                    </div>

                                </div>





                            </div>


                        </div>

                        <div class="tab-pane fade " id="gallery" role="tabpanel">

                            <div class="row">

                                @for($i=0;$i<15;$i++)


                                    <div class="col-md-6">

                                        <div class="row">
                                            <div class="col-md-4">
                                                <label class="form-label" for="title">فایل</label>
                                                <div class="input-group">
                                                    <input type="text" id="input-gallery-{{$i + 1}}" class="form-control" name="files[]"
                                                           aria-label="Image" aria-describedby="button-gallery-{{$i + 1}}" value="{{isset($product->galleries[$i]) ? $product->galleries[$i]->file : ''}}">
                                                    <div class="input-group-append">
                                                        <button class="btn btn-outline-secondary" type="button" id="button-gallery-{{$i + 1}}">آپلود</button>
                                                    </div>
                                                </div>
                                            </div>

                                            <div class="col-md-8">
                                                <label class="form-label" for="title">توضیح</label>
                                                <div class="input-group">
                                                    <input type="text" id="notes" class="form-control" name="notes[]" aria-label="Image" value="{{isset($product->galleries[$i]) ? $product->galleries[$i]->desc : ''}}" >
                                                </div>
                                            </div>
                                        </div>

                                    </div>

                                @endfor
                            </div>

                        </div>


                        @foreach($field_groups->where('type','products') as $group)

                            <div class="tab-pane fade " id="{{$group->name}}" role="tabpanel">


                                <div class="row g-3">

                                    <div class="col-md-12">

                                        <div class="row">

                                            @foreach($group->fields as $field)



                                                @if($field->type == 'string')
                                                    <div class="col-md-6">
                                                        <label for="{{$field->name}}" class="form-label">{{$field->title}}</label>
                                                        <input type="text" class="form-control" name="fields[{{$field->name}}]" id="{{$field->name}}" value="{{isset($product) && $product->fields->where('field_id',$field->id)->first() != null ? $product        ->fields->where('field_id',$field->id)->first()->value->value : ''}}" />
                                                    </div>
                                                @endif


                                            @endforeach


                                        </div>

                                    </div>




                                </div>


                            </div>


                        @endforeach
                        <div class="pt-4">
                            <button type="submit" name="save" class="btn btn-primary me-sm-3 me-1">ثبت</button>
                            <a href="{{route('admin.product.index')}}" type="reset" class="btn btn-label-secondary">انصراف</a>
                        </div>

                    </form>
                </div>
            </div>
        </div>
    </div>


    <script src="{{ asset('modules/core/js/slug-edit.js') }}"></script>

@endsection
