<?php

use Modules\Product\app\Http\Controllers\Dashboard\Frest\ProductColorController;
use Modules\Product\app\Http\Controllers\Dashboard\Frest\ProductGuaranteeController;
use Modules\Product\app\Http\Controllers\Dashboard\Frest\ProductMaterialController;

Route::as('admin.')->prefix('admin')->namespace('Dashboard\Frest')->middleware('auth:admin', 'check_role_admin')->group(function () {


    Route::Resource('product', 'ProductController');

    Route::get('product-color/{product}', [ProductColorController::class, 'index'])->name('product-colors');
    Route::get('product-color/{product}/create', [ProductColorController::class, 'create'])->name('product-colors.create');
    Route::post('product-color/{product}', [ProductColorController::class, 'store'])->name('product-colors.store');
    Route::get('product-color/{productColor}/edit', [ProductColorController::class, 'edit'])->name('product-colors.edit');
    Route::put('product-color/{productColor}/update', [ProductColorController::class, 'update'])->name('product-colors.update');
    Route::delete('product-color/{productColor}/delete', [ProductColorController::class, 'destroy'])->name('product-colors.destroy');


    Route::get('product-guarantee/{product}', [ProductGuaranteeController::class, 'index'])->name('product-guarantees');
    Route::get('product-guarantee/{product}/create', [ProductGuaranteeController::class, 'create'])->name('product-guarantees.create');
    Route::post('product-guarantee/{product}', [ProductGuaranteeController::class, 'store'])->name('product-guarantees.store');
    Route::get('product-guarantee/{productGuarantee}/edit', [ProductGuaranteeController::class, 'edit'])->name('product-guarantees.edit');
    Route::put('product-guarantee/{productGuarantee}/update', [ProductGuaranteeController::class, 'update'])->name('product-guarantees.update');
    Route::delete('product-guarantee/{productGuarantee}/delete', [ProductGuaranteeController::class, 'destroy'])->name('product-guarantees.destroy');


    Route::get('product-material/{product}', [ProductMaterialController::class, 'index'])->name('product-materials');
    Route::get('product-material/{product}/create', [ProductMaterialController::class, 'create'])->name('product-materials.create');
    Route::post('product-material/{product}', [ProductMaterialController::class, 'store'])->name('product-materials.store');
    Route::get('product-material/{productMaterial}/edit', [ProductMaterialController::class, 'edit'])->name('product-materials.edit');
    Route::put('product-material/{productMaterial}/update', [ProductMaterialController::class, 'update'])->name('product-materials.update');
    Route::delete('product-material/{productMaterial}/delete', [ProductMaterialController::class, 'destroy'])->name('product-materials.destroy');




    Route::as('bulk.')->prefix('/bulk')->group(function () {
        Route::get('/products', 'ProductController@bulkAction')->name('products');
    });
});
