<?php

namespace Modules\Permission\app\Http\Controllers\Dashboard\Frest;

use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\Session;
use Modules\Role\app\Models\Permission;
use Modules\Role\app\Http\Requests\Dashboard\Frest\Permission\PermissionStoreRequest;
use Modules\Role\app\Http\Requests\Dashboard\Frest\Permission\PermissionUpdateRequest;

class PermissionController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        $permmissions = Permission::latest()->paginate(15);



        return view('role::Dashboard.Frest.permmission.index',compact('permmissions'));
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        //
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(PermissionStoreRequest $request)
    {


        Permission::create([
            'title' => $request->title,
            'key' => $request->key,
            'desc' => $request->desc,
        ]);

        Session::flash('success','با موفقیت انجام شد');
        return redirect()->back();
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        //
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(PermissionUpdateRequest $request, Permission $permmission)
    {


        $permmission->title = $request->title;
        $permmission->key = $request->key;
        $permmission->desc = $request->desc;
        $permmission->save();

        Session::flash('success','با موفقیت انجام شد');
        return redirect()->back();
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy(Permission $permmission)
    {
        $permmission->delete();

        Session::flash('success','با موفقیت انجام شد');
        return redirect()->back();

    }
}
