<?php

namespace Modules\Role\app\Http\Controllers\Dashboard\Frest;


use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\Session;
use Modules\Category\app\Models\Category;
use Modules\Role\app\Models\PermissionGroup;
use Modules\Role\app\Models\Role;
use Modules\Role\app\Http\Requests\Dashboard\Frest\Role\RoleStoreRequest;
use Modules\Role\app\Http\Requests\Dashboard\Frest\Role\RoleUpdateRequest;

class RoleController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        $this->authorize('user.access');
        $roles = Role::latest()->paginate(20);
        $categories = Category::whereState(1)->whereNull('parent_id')->with(['children'])->get();

        $permission_groups = PermissionGroup::with(['permissions'])->latest()->get();



        return view('role::Dashboard.Frest.role.index', compact('roles','permission_groups','categories'));
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
       //

    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(RoleStoreRequest $request)
    {
        $this->authorize('user.access');

        $role = Role::create([
            'title' => $request->title,
            'key' => $request->key,
            'image' =>  $request->image == null ? null :  File::fileUpload($request->image,'roles'),
            'desc' => $request->desc,
        ]);



        $role->permissions()->attach($request->permissions);

        $role->categories()->attach($request->categories);

        Session::flash('success','با موفقیت انجام شد');
        return redirect()->route('admin.role.index');

    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit(Role $role)
    {
     //

    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(RoleUpdateRequest $request,Role $role)
    {

        $this->authorize('user.access');

        $role->title = $request->title;
        $role->key = $request->key;
        $role->image = $request->image == null ? $role->image :  File::fileUpload($request->image,'roles');
        $role->desc  = $request->desc;
        $role->update();


        $role->permissions()->sync($request->permissions);
        $role->categories()->sync($request->categories);


        Session::flash('success','با موفقیت انجام شد');
        return redirect()->route('admin.role.index');

    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy(Role $role)
    {
        $this->authorize('user.access');
        $role->delete();

        Session::flash('success','با موفقیت انجام شد');
        return redirect()->route('admin.role.index');

    }
}
