<?php

namespace Modules\Role\app\Http\Requests\Dashboard\Frest\Permission;

use App\Model\Permission;
use Illuminate\Validation\Rule;
use Illuminate\Foundation\Http\FormRequest;

class PermissionUpdateRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     *
     * @return bool
     */
    public function authorize()
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array
     */
    public function rules(Permission $permmission)
    {
        return [
            'title' => 'required',
            'key' => ['bail' , 'required', Rule::unique('permissions')->ignore($permmission->id) ],
        ];
    }
}
