<?php

namespace Modules\Role\app\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Permission extends Model
{
    use SoftDeletes;
    protected $fillable = ['title','key','desc','group'];


    public function roles(){

        return $this->belongsToMany(Role::class,'permission_role');

    }

    public function group(){
        return $this->belongsTo(PermissionGroup::class,'group','name');
    }
}
