<?php

namespace Modules\Role\app\Models;


use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;
use Modules\Admin\app\Models\Admin;
use Modules\Category\app\Models\Category;

class Role extends Model
{
    use SoftDeletes;
    protected $fillable = ['title','key','image','desc','state'];




    public function users() {
        return $this->belongsToMany(Admin::class,'role_model','role_id','model_id')
            ->where('model_type','=','Modules\Admin\app\Models\Admin');
    }


    public function permissions(){
        return  $this->belongsToMany(Permission::class,'permission_role');
    }

    public function categories(){

        return  $this->belongsToMany(Category::class,'category_role');

    }



}
