@extends('core::Dashboard.Frest.Layouts.master')



@section('content')



    <div class="container-xxl flex-grow-1 container-p-y">
        <h4 class="py-3 breadcrumb-wrapper mb-2">لیست نقش‌ها</h4>

        <p>
            یک نقش، دسترسی به منوها و امکانات از پیش تعریف شده را فراهم می کند که <br>
            بر اساس نقش اختصاص یافته، مدیر می تواند دسترسی های مورد نیاز کاربر را ایجاد کند.
        </p>
        <!-- Role cards -->
        <div class="row g-4">
            @foreach($roles as $role)
                <div class="col-xl-4 col-lg-6 col-md-6">
                    <div class="card">
                        <div class="card-body">
                            <div class="d-flex justify-content-between mb-1">
                                <h6 class="fw-normal">{{$role->users->count()}} کاربر در مجموع</h6>

                                <ul class="list-unstyled d-flex avatar-group mb-0">
                                    @foreach($role->users as $user)
                                        <li data-bs-toggle="tooltip" data-popup="tooltip-custom" data-bs-placement="top" title="{{$user->family}}" class="avatar avatar-sm pull-up">
                                            <img class="rounded-circle" src="{{$user->image}}" alt="Avatar">
                                        </li>
                                    @endforeach
                                </ul>

                            </div>
                            <div class="d-flex justify-content-between align-items-end">
                                <div class="role-heading">
                                    <h4 class="mb-1">{{$role->title}}</h4>
                                    <a href="javascript:;" data-bs-toggle="modal" data-bs-target="#editRole-{{$role->id}}" class="role-edit-modal"><small>ویرایش نقش</small></a>
                                </div>
                                <a href="javascript:void(0);" class="text-muted"><i class="bx bx-trash" onclick="event.preventDefault();confirmDelete('delete-{{$role->id}}')"></i></a>

                                <form id="delete-{{$role->id}}" action="{{ route('admin.role.destroy', $role->id) }}" method="POST" style="display: none;">
                                    {{ csrf_field() }}
                                    {{ method_field('DELETE') }}
                                </form>

                                <div class="modal fade" id="editRole-{{$role->id}}" aria-hidden="true">
                                    <div class="modal-dialog modal-lg modal-dialog-centered modal-add-new-role">
                                        <div class="modal-content p-3 p-md-5">
                                            <button type="button" class="btn-close btn-pinned" data-bs-dismiss="modal" aria-label="Close"></button>
                                            <div class="modal-body">
                                                <div class="text-center mb-4">
                                                    <h3 class="role-title">{{$role->title}}</h3>
                                                    <p>مجوزهای نقش را تنظیم کنید</p>
                                                </div>
                                                <!-- Add role form -->
                                                <form id="addRoleForm"  action="{{route('admin.role.update',$role->id)}}" method="post"  class="row g-3">
                                                    @csrf
                                                    @method('patch')
                                                    <div class="col-7 mb-6">
                                                        <label class="form-label" for="modalRoleName">نام نقش</label>
                                                        <input type="text" id="title" name="title" class="form-control" placeholder="نام نقش را وارد کنید" tabindex="-1" value="{{$role->title}}">
                                                    </div>

                                                    <div class="col-5 mb-6">
                                                        <label class="form-label" for="modalRoleName">کلید نقش</label>
                                                        <input type="text" id="key" name="key" class="form-control" placeholder="کلید را وارد کنید" tabindex="-1" value="{{$role->key}}">
                                                    </div>

                                                    <div class="col-10 mb-10">
                                                        <label for="selectpickerSelectDeselect" class="form-label">دسترسی به دسته بندی های</label>
                                                        <select id="selectpickerSelectDeselect" name="categories[]" class="selectpicker w-100" data-style="btn-default" multiple data-actions-box="true">
                                                            @foreach($categories as $category)
                                                                @include('category::Dashboard.Frest.category.listCategoryShow',['row' => 0,'category' => $category,'model' => $role])
                                                            @endforeach
                                                        </select>
                                                    </div>

                                                    <div class="col-md-2">
                                                        <span>*</span>
                                                        <label class="form-label" for="state">وضعیت</label>
                                                        <div class="position-relative">
                                                            <select required id="state" name="state" class="form-select" >
                                                                <option value="1" {{'1' == $role->state ? 'selected' : ''}}>فعال</option>
                                                                <option value="0" {{'2' == $role->state ? 'selected' : ''}}>غیر فعال</option>
                                                            </select>
                                                        </div>
                                                    </div>

                                                    <div class="col-12">
                                                        <h5>مجوزهای نقش</h5>
                                                        <!-- Permission table -->
                                                        <div class="table-responsive">
                                                            <table class="table table-flush-spacing">
                                                                <tbody>
                                                                <tr>
                                                                    <td class="text-nowrap">
                                                                        دسترسی مدیریت
                                                                        <i class="bx bx-info-circle bx-xs" data-bs-toggle="tooltip" data-bs-placement="top" title="دسترسی کامل به سیستم را اجازه می‌دهد"></i>
                                                                    </td>
                                                                    <td>
                                                                        <div class="form-check">
                                                                            <input class="form-check-input" type="checkbox" id="permissions" onClick="toggle(this,'permissions[]')">
                                                                            <label class="form-check-label"  for="selectAll"> انتخاب همه </label>
                                                                        </div>
                                                                    </td>
                                                                </tr>
                                                                @foreach($permission_groups as $group)
                                                                <tr>
                                                                    <td class="text-nowrap">{{$group->title}}</td>
                                                                    <td>
                                                                        <div class="d-flex">
                                                                            @foreach($group->permissions as $permission)
                                                                                <div class="form-check mb-0 me-3 me-lg-5">
                                                                                    <input class="form-check-input" type="checkbox" id="permissions[]" name="permissions[]" {{in_array($permission->id,$role->permissions->pluck('id')->toArray()) ? 'checked' : ''}}   value="{{$permission->id}}">
                                                                                    <label class="form-check-label" for="permissions[]"> {{$permission->title}} </label>
                                                                                </div>
                                                                            @endforeach
                                                                        </div>
                                                                    </td>
                                                                </tr>
                                                                @endforeach

                                                                </tbody>
                                                            </table>
                                                        </div>
                                                        <!-- Permission table -->
                                                    </div>
                                                    <div class="col-12 text-center">
                                                        <button type="submit" class="btn btn-primary me-sm-3 me-1">ثبت</button>
                                                        <button type="reset" class="btn btn-label-secondary" data-bs-dismiss="modal" aria-label="Close">
                                                            انصراف
                                                        </button>
                                                    </div>
                                                </form>
                                                <!--/ Add role form -->
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            @endforeach
                <div class="col-xl-4 col-lg-6 col-md-6">
                    <div class="card h-100">
                        <div class="row h-100">
                            <div class="col-sm-7">
                                <div class="card-body text-sm-end text-center ps-sm-0">
                                    <button data-bs-target="#newRole" data-bs-toggle="modal" class="btn btn-primary mb-3 text-nowrap add-new-role">
                                        افزودن نقش جدید
                                    </button>
                                    <p class="mb-0">اگر نقشی وجود ندارد اضافه کنید</p>
                                </div>
                            </div>

                            <div class="modal fade" id="newRole" tabindex="-1" aria-hidden="true">
                                <div class="modal-dialog modal-lg modal-dialog-centered modal-add-new-role">
                                    <div class="modal-content p-3 p-md-5">
                                        <button type="button" class="btn-close btn-pinned" data-bs-dismiss="modal" aria-label="Close"></button>
                                        <div class="modal-body">
                                            <div class="text-center mb-4">
                                                <h3 class="role-title">نام نقش رو وارد کنید</h3>
                                                <p>مجوزهای نقش را تنظیم کنید</p>
                                            </div>
                                            <!-- Add role form -->
                                            <form action="{{route('admin.role.store')}}" method="post" class="row g-3" >
                                                @csrf
                                                <div class="col-7 mb-4">
                                                    <label class="form-label" for="modalRoleName">نام نقش</label>
                                                    <input type="text" id="title" name="title" class="form-control" placeholder="نام نقش را وارد کنید" tabindex="-1" value="{{old('title')}}">
                                                </div>

                                                <div class="col-5 mb-4">
                                                    <label class="form-label" for="modalRoleName">کلید نقش</label>
                                                    <input type="text" id="key" name="key" class="form-control" placeholder="کلید را وارد کنید" tabindex="-1" value="{{old('key')}}">
                                                </div>

                                                <div class="col-10 mb-10">
                                                    <label for="selectpickerSelectDeselect" class="form-label">دسترسی به دسته بندی های</label>
                                                    <select id="selectpickerSelectDeselect" name="categories[]" class="selectpicker w-100" data-style="btn-default" multiple data-actions-box="true">
                                                        @foreach($categories as $category)
                                                            @include('category::Dashboard.Frest.category.listCategoryShow',['row' => 0,'category' => $category ])
                                                        @endforeach
                                                    </select>
                                                </div>

                                                <div class="col-md-2">
                                                    <span>*</span>
                                                    <label class="form-label" for="state">وضعیت</label>
                                                    <div class="position-relative">
                                                        <select required id="state" name="state" class="form-select" >
                                                            <option value="1" {{'1' == old('state') ? 'selected' : ''}}>فعال</option>
                                                            <option value="0" {{'2' == old('state') ? 'selected' : ''}}>غیر فعال</option>
                                                        </select>
                                                    </div>
                                                </div>

                                                <div class="col-12">
                                                    <h5>مجوزهای نقش</h5>
                                                    <!-- Permission table -->
                                                    <div class="table-responsive">
                                                        <table class="table table-flush-spacing">
                                                            <tbody>
                                                            <tr>
                                                                <td class="text-nowrap">
                                                                    دسترسی مدیریت
                                                                    <i class="bx bx-info-circle bx-xs" data-bs-toggle="tooltip" data-bs-placement="top" title="دسترسی کامل به سیستم را اجازه می‌دهد"></i>
                                                                </td>
                                                                <td>
                                                                    <div class="form-check">
                                                                        <input class="form-check-input" type="checkbox" id="selectAll" onClick="toggle(this,'permissions[]')">
                                                                        <label class="form-check-label" for="selectAll"> انتخاب همه </label>
                                                                    </div>
                                                                </td>
                                                            </tr>
                                                            @foreach($permission_groups as $group)
                                                                <tr>
                                                                    <td class="text-nowrap">{{$group->title}}</td>
                                                                    <td>
                                                                        <div class="d-flex">
                                                                            @foreach($group->permissions as $permission)
                                                                                <div class="form-check mb-0 me-3 me-lg-5">
                                                                                    <input class="form-check-input" type="checkbox" id="permissions[]" name="permissions[]" value="{{$permission->id}}">
                                                                                    <label class="form-check-label" for="permissions[]"> {{$permission->title}} </label>
                                                                                </div>
                                                                            @endforeach
                                                                        </div>
                                                                    </td>
                                                                </tr>
                                                            @endforeach

                                                            </tbody>
                                                        </table>
                                                    </div>
                                                    <!-- Permission table -->
                                                </div>
                                                <div class="col-12 text-center">
                                                    <button type="submit" class="btn btn-primary me-sm-3 me-1">ثبت</button>
                                                    <button type="reset" class="btn btn-label-secondary" data-bs-dismiss="modal" aria-label="Close">
                                                        انصراف
                                                    </button>
                                                </div>
                                            </form>
                                            <!--/ Add role form -->
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
        </div>

    </div>
    <!--/ Content -->




@endsection


@section('script')
    <script src="{{asset('modules/core/js/app-access-roles.js')}}"></script>
    <script src="{{asset('modules/core/js/modal-add-role.js')}}"></script>
@endsection





