<?php

namespace Modules\Service\app\Http\Controllers\Dashboard\Frest;




use App\Http\Controllers\Controller;
use Barryvdh\DomPDF\Facade\Pdf;
use Carbon\Carbon;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Session;
use Maatwebsite\Excel\Facades\Excel;
use Modules\Category\app\Models\Category;
use Modules\Core\app\Http\Controllers\Helpers\File;
use Modules\Core\app\Http\Controllers\Helpers\Str;
use Modules\News\app\Models\News;
use Modules\News\app\Models\Source;
use Modules\News\app\Models\Type;
use Modules\News\app\Http\Requests\Dashboard\Frest\News\NewsStoreRequest;
use Modules\News\app\Http\Requests\Dashboard\Frest\News\NewsUpdateRequest;
use Modules\NovinHub\Http\Helpers\NovinHub;
use Modules\Service\app\Http\Requests\Dashboard\Frest\Service\ServiceStorRequest;
use Modules\Service\app\Http\Requests\Dashboard\Frest\Service\ServiceUpdateRequest;
use Modules\Service\app\Models\Service;
use Modules\Service\app\Models\ServiceModel;
use Modules\Tag\app\Models\Tag;
use Modules\User\app\Http\Requests\Dashboard\Frest\Education\EducationUpdateRequest;
use Modules\User\app\Models\Education;


class ServiceController extends Controller
{

    public function index()
    {

        $this->authorize('news.access');

        $services = Service::where('model',Request()->model)->latest()->get();

        $services = Service::all();
        return view('service::Dashboard.Frest.service.index' ,compact('services'));
    }

    public function store(ServiceStorRequest $request)
    {
        $service = Service::create([
            'title' => $request->title,
            'name' => $request->name,
            'model' => $request->model,
        ]);

        session::flash('success','با موفقیت انجام شد');
        return redirect()->route('admin.service.index');
    }

    public function show($id)
    {

        $service = Service::find($id);

        $row = ServiceModel::with(['news','ads','products'])
            ->where('service_id',$service->id)->orderBy('order','asc')->get();



        return view('service::Dashboard.Frest.service.item.index',compact('service','row'));


    }
    public function update(ServiceUpdateRequest $request, $id)
    {
        $service = Service::find($id);

        $service->title = $request->title;
        $service->name = $request->name;
        $service->model = $request->model;
        $service->update();

        Session::flash('success','با موفقیت انجام شد');
        return redirect()->route('admin.service.index');
    }
    public function destroy(Service $service)
    {
        $service->delete();

        Session::flash('success','با موفقیت انجام شد');
        return redirect()->back();
    }

    public function sortable(){

        foreach (Request()->orders as $index => $order){

           ServiceModel::where('id',$order)->update(
                ['order' => $index]);

        }


    }

    public function bulkAction()
    {

        $items = [];
        $items = explode(',',Request()->items);

        if(isset($_GET['delete']))
        {
//            $this->authorize('education.delete');
            Service::whereIn('id',$items)->delete();
        }
//        if (isset($_GET['unPublish']))
//        {
////            $this->authorize('product.edit');
//            Service::whereIn('id',$items)->update([
//                'state' => 0
//            ]);
//        }
//        if(isset($_GET['publish']))
//        {
////            $this->authorize('product.edit');
//            Service::whereIn('id',$items)->update([
//                'state' => 1
//            ]);
//        }

        session::flash('success','با موفقیت انجام شد');
        return redirect()->back();

    }

}
