<?php

namespace Modules\Service\app\Http\Requests\Dashboard\Frest\Service;

use Illuminate\Foundation\Http\FormRequest;
use Illuminate\Validation\Rule;

class ServiceUpdateRequest extends FormRequest
{
    /**
     * Get the validation rules that apply to the request.
     */
    public function rules(): array
    {
        $serviceId = $this->route('service');
        return [
//            'title' => [
//                'required',
//                Rule::unique('services', 'title')->ignore($serviceId),
//            ],
            'name' => [
                'required',
                Rule::unique('services', 'name')->ignore($serviceId),
            ],
        ];
    }

    /**
     * Determine if the user is authorized to make this request.
     */
    public function authorize(): bool
    {
        return true;
    }
}
