<?php

namespace Modules\Service\app\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Modules\Ads\app\Models\Ads;
use Modules\Competition\app\Models\Competition;
use Modules\News\app\Models\News;

class Service extends Model
{
    use HasFactory;

    protected $fillable = ['title','name','template_id','model'];

    public function news() {
        return $this->belongsToMany(News::class,'service_model','service_id','model_id')
            ->where('model_type','=','Modules\News\app\Models\News');
    }

    public function competitions() {
        return $this->belongsToMany(Competition::class,'service_model','service_id','model_id')
            ->where('model_type','=','Modules\Competition\app\Models\Competition');
    }

    public function ads() {
        return $this->belongsToMany(Ads::class,'service_model','service_id','model_id')
            ->where('model_type','=','Modules\News\app\Models\Ads');
    }

    public function serviceModel() {
        return $this->hasMany(ServiceModel::class,'service_id');
    }

}
