<?php

namespace Modules\Service\app\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Modules\Ads\app\Models\Ads;
use Modules\Competition\app\Models\Competition;
use Modules\News\app\Models\News;
use Modules\Product\app\Models\Product;

class ServiceModel extends Model
{
    use HasFactory;

    protected $table = 'service_model';
    public $lang = "fa";

    protected $fillable = ['service_id', 'model_type','model_id','order'];




    public function scopeActive($query,$service,$model,$order,$lang='en')
    {
        $date = date('Y-m-d H:i:s');
        $this->lang = $lang;

        return $query
            ->whereHas('service',function ($query) use ($service){
                  $query->where('name',$service);
            })
            ->when($model=='news',function ($query) use ($order) {
                $query->has('newsActive')->with(['newsActive']);
            })
            ->when($model=='ads',function ($query) use ($order) {
                $query->has('adsActive')->with(['adsActive']);
            })
            ->when($model=='products',function ($query) use ($order) {
                $query->has('productsActive')->with(['productsActive']);
            })
            ->when($model=='competitions',function ($query) use ($order) {
                $query->has('competitionsActive')->with(['competitionsActive']);
            })
            ->orderBy('order',$order);
    }



    public function services() {
        return $this->morphTo(ServiceModel::class,'model_type','model_id');
    }
    public function news() {
        return $this->belongsTo(News::class,'model_id');
    }

    public function ads() {
        return $this->belongsTo(Ads::class,'model_id');
    }

    public function products() {
        return $this->belongsTo(Product::class,'model_id');
    }

    public function competitions()
    {
        return $this->belongsTo(Competition::class,'model_id');
    }

    public function newsActive() {
        $date = date('Y-m-d H:i:s');
        $lang = Request()->path() == "/" ? 'fa' : 'fa';
        return $this->belongsTo(News::class,'model_id')
            ->where(function($q) use ($date) {
                $q->whereRaw('publish_up IS NULL OR publish_up < ?', [$date]);
            })
            ->where(function($q) use ($date) {
                $q ->whereRaw('publish_down IS NULL OR publish_down > ?', [$date]);

            })->where('state','=',1)->where('lang','=',$lang);
    }

    public function adsActive() {
        $date = date('Y-m-d H:i:s');

        $lang = Request()->path() == "/" ? 'fa' : 'fa';

        return $this->belongsTo(Ads::class,'model_id')
            ->where(function ($q) use ($lang){
                $q ->where('lang','=',$lang)->where('state','=',1);
            })
            ->where(function($q) use ($date) {
                $q->whereRaw('publish_up IS NULL OR publish_up < ?', [$date]);
            })
            ->where(function($q) use ($date) {
                $q ->whereRaw('publish_down IS NULL OR publish_down > ?', [$date]);
            });
    }

    public function productsActive() {
        $date = date('Y-m-d H:i:s');
        $lang = Request()->path() == "/" ? 'fa' : 'fa';
        return $this->belongsTo(Product::class,'model_id')
            ->where(function($q) use ($date) {
                $q->whereRaw('publish_up IS NULL OR publish_up < ?', [$date]);
            })
            ->where(function($q) use ($date) {
                $q ->whereRaw('publish_down IS NULL OR publish_down > ?', [$date]);
            })->where('state','=',1)->where('lang','=',$lang);
    }

    public function competitionsActive() {
        $date = date('Y-m-d H:i:s');
        return $this->belongsTo(competition::class,'model_id')
            ->where(function($q) use ($date) {
                $q->whereRaw('start_time IS NULL OR start_time < ?', [$date]);
            })
            ->where(function($q) use ($date) {
                $q ->whereRaw('end_time IS NULL OR end_time > ?', [$date]);
            })->where('status','=',1);
    }


    public function service(){
        return $this->belongsTo(Service::class,'service_id');
    }
}
