@extends('core::Dashboard.Frest.Layouts.master')

@section('title')
    لیست سرویس ها
@endsection

@section('style')
@endsection

@section('script')

@endsection

@section('content')
    <div class="card" style="margin-bottom:15px; ">
        <p class="demo-inline-spacing">
            <button type="button" class="btn btn-icon me-2 btn-primary" type="button" data-bs-toggle="collapse"
                data-bs-target=".multi-collapse" aria-expanded="false"
                aria-controls="multiCollapseExample1 multiCollapseExample2">
                <i class="bx bx-search bx-sm"></i>
            </button>


        </p>

        <section>
            <div class="row">

                <div class="row">
                    <div class="col-12 col-md-12">
                        <div class="collapse multi-collapse" id="multiCollapseExample2">
                            <div class="col-md-12" style="padding: 0.8%;">
                                <form id="filter" action="{{route('admin.category.index')}}"
                                    method="get">
                                    <div class="row">
                                        <div class="col-md-2">
                                            <input type="text" id="q" name="q" class="form-control" placeholder="جستجو"
                                                value="{{ old('q') }}">
                                        </div>
                                        <div class="col-md-2">
                                            <button onclick="submitForm('filter')" name="filter" type="button"
                                                class="btn btn-primary me-1">جستجو</button>
                                        </div>
                                    </div>
                                </form>
                            </div>
                        </div>
                    </div>
                </div>



            </div>
        </section>
    </div>


    <div class="card">
        <x-modal id="add_education" size="sm" header="ثبت سرویس نمایشی">
            <form id="formData" action="{{ route('admin.service.store') }}" method="post">
                {{ csrf_field() }}

                <div class="tab-pane fade active show" id="tab1" role="tabpanel">
                    <div class="row g-3">
                        <div class="col-md-12">
                            <div class="row">
                                <div class="col-md-6">
                                    <span>*</span>
                                    <label class="form-label" for="title">عنوان</label>
                                    <input type="text" id="title" name="title" class="form-control"
                                           placeholder="عنوان" value="">
                                    @if ($errors->has('title'))
                                        <div data-field="title" class="text-danger">{{ $errors->first('title') }}
                                        </div>
                                    @endif
                                </div>
                                <div class="col-md-6">
                                    <span>*</span>
                                    <label class="form-label" for="title">کلید</label>
                                    <input type="text" id="slug" name="name" class="form-control"
                                           placeholder="کلید" value="">
                                    @if ($errors->has('name'))
                                        <div data-field="title" class="text-danger">{{ $errors->first('name') }}
                                        </div>
                                    @endif
                                </div>
                                <div class="col-md-6">
                                    <span>*</span>
                                    <label class="form-label" for="state">مدل</label>
                                    <div class="position-relative">
                                        <select id="state" name="model" class="form-select">
                                            <option value="news" {{ 'news' == old('model') ? 'selected' : '' }}>خبر ها</option>
                                            <option value="ads" {{ 'ads' == old('model') ? 'selected' : '' }}>بنر ها</option>
                                            <option value="competitions" {{ 'competitions' == old('model') ? 'selected' : '' }}>رویداد ها</option>
                                            <option value="portfolio" {{ 'portfolio' == old('model') ? 'selected' : '' }}>نمونه کار ها</option>
                                        </select>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="pt-4">
                    <button type="submit" name="save" class="btn btn-primary me-sm-3 me-1">ثبت</button>
                    <a href="{{ route('admin.service.index') }}" type="reset"
                       class="btn btn-label-secondary">انصراف</a>
                </div>
            </form>
        </x-modal>
        <form action="{{ route('admin.bulk.services') }}" method="get">
            <p class="demo-inline-spacing">
                <button type="button" class="btn btn-primary me-1" data-bs-toggle="modal" data-bs-target="#add_education">
                    جدید
                </button>
{{--                <button name="publish" type="submit" class="btn btn-success me-1">انتشار</button>--}}
{{--                <button name="unPublish" type="submit" class="btn btn-gray me-1">غیر انتشار</button>--}}
                <button name="delete" type="submit" class="btn btn-danger me-1">حذف</button>
            </p>
            <input type="text" id="items" name="items" value="" style="display: none;">
        </form>
            <h5 class="card-header">لیست سرویس های نمایشی</h5>
            <div class="table-responsive text-nowrap">
                <table class="table table-sm">
                    <thead>
                        <tr>
                            <th>
                                <div class="bulk-ids checkbox-primary m-r-15">
                                    <input id="bulk-ids" onClick="toggle(this)" type="checkbox">
                                    <label for="bulk-ids">#</label>
                                </div>
                            </th>
                            <th>عنوان</th>
                            <th>کلید</th>
                            <th>مدل</th>
                            <th>عملیات</th>
                        </tr>
                    </thead>
                    <tbody>

                        @foreach ($services as $service)
                            <tr>
                                <th>
                                    <div class="bulk-ids checkbox-primary m-r-15">
                                        <input id="bulk-ids" onClick="syncItems(this)" name="ids[]" value="{{$service->id}}" type="checkbox">
                                        <label for="bulk-ids"></label>
                                    </div>
                                </th>
                                <td>
                                <a href="{{route('admin.service.show',$service->id)}}">{{$service->title}}</a>
                                </td>

                                <td>
                                    <a href="{{route('admin.service.show',$service->id)}}">{{$service->name}}</a>
                                </td>

                                <td>
                                    @if($service->model == 'news')
                                        خبر ها
                                    @elseif($service->model == 'ads')
                                        بنر ها
                                    @elseif($service->model == 'competitions')
                                        رویداد ها
                                    @elseif($service->model == 'portfolio')
                                        نمونه کار ها
                                    @endif
                                </td>

                                <td>
                                    <div class="dropdown">
                                        <button type="button" class="btn p-0 dropdown-toggle hide-arrow"
                                                data-bs-toggle="dropdown"><i class="bx bx-dots-vertical-rounded"></i></button>
                                        <div class="dropdown-menu">
                                            <button type="button" class="dropdown-item" data-bs-toggle="modal" data-bs-target="#edit_education-{{$service->id }}">
                                                <i class="bx bx-edit-alt me-1"></i>ویرایش
                                            </button>

                                            <button class="dropdown-item"
                                                    onclick="event.preventDefault();confirmDelete('delete-{{ $service->id }}')"><i
                                                    class="bx bx-trash me-1"></i>حذف</button>
                                            <form id="delete-{{ $service->id }}"
                                                  action="{{ route('admin.service.destroy', $service->id) }}" method="POST"
                                                  style="display: none;">
                                                {{ csrf_field() }}
                                                {{ method_field('DELETE') }}
                                            </form>
                                        </div>
                                    </div>
                                </td>
                            </tr>
                        @endforeach

                        @foreach ($services as $service)
                            <x-modal id="edit_education-{{$service->id}}" size="sm" header="ویرایش  سرویس نمایشی">
                                <form id="formData" action="{{ route('admin.service.update', $service->id) }}" method="post">
                                    {{ csrf_field() }}
                                    @method('patch')
                                    <div class="tab-pane fade active show" id="tab1" role="tabpanel">
                                        <div class="row g-3">
                                            <div class="col-md-12">
                                                <div class="row">
                                                    <div class="col-md-6">
                                                        <span>*</span>
                                                        <label class="form-label" for="title">عنوان</label>
                                                        <input type="text" id="title" name="title" class="form-control"
                                                               placeholder="عنوان" value="{{$service->title}}">
                                                        @if ($errors->has('title'))
                                                            <div data-field="title" class="text-danger">{{ $errors->first('title') }}
                                                            </div>
                                                        @endif
                                                    </div>
                                                    <div class="col-md-6">
                                                        <span>*</span>
                                                        <label class="form-label" for="title">کلید</label>
                                                        <input type="text" id="slug" name="name" class="form-control"
                                                               placeholder="کلید" value="{{ $service->name }}">
                                                        @if ($errors->has('name'))
                                                            <div data-field="title" class="text-danger">{{ $errors->first('name') }}
                                                            </div>
                                                        @endif
                                                    </div>
                                                    <div class="col-md-6">
                                                        <span>*</span>
                                                        <label class="form-label" for="state">وضعیت</label>
                                                        <div class="position-relative">
                                                            <select id="state" name="model" class="form-select">
                                                                @php
                                                                    $options = [
                                                                        'news' => 'خبر ها',
                                                                        'ads' => 'بنر ها',
                                                                        'competitions' => 'رویداد ها',
                                                                        'portfolio' => 'نمونه کار ها',
                                                                    ];
                                                                @endphp
                                                                @foreach($options as $value => $label)
                                                                    <option value="{{ $value }}" {{ $service->model == $value ? 'selected' : '' }}>{{ $label }}</option>
                                                                @endforeach
                                                            </select>

                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="pt-4">
                                        <button type="submit" name="save" class="btn btn-primary me-sm-3 me-1">ثبت</button>
                                        <a href="{{ route('admin.service.index') }}" type="reset"
                                           class="btn btn-label-secondary">انصراف</a>
                                    </div>
                                </form>
                            </x-modal>
                        @endforeach

                    </tbody>
                </table>


            </div>

    </div>
@endsection
