@extends('core::Dashboard.Frest.Layouts.master')

@section('title')
   لیستم آیتم های سرویس ها
@endsection

@section('style')

@endsection

@section('script')
    <script src="{{asset('modules/core/vendor/libs/sortablejs/sortable.js')}}" ></script>
    <script src="https://cdn.jsdelivr.net/npm/axios/dist/axios.min.js"></script>
    <script>

        const cloneSource1 = document.getElementById('clone-source-1');


        Sortable.create(cloneSource1, {
            animation: 150,
            group: {
                name: 'cloneList',
                pull: 'clone',
                revertClone: true
            },
            onUpdate: function (evt) {
                const list = [];
                const orders = document.getElementsByName('orders[]');
                for (var i = 0; i <orders.length; i++) {
                    var item = orders[i];
                    list.push(item.value);
                }


                    axios.post('/admin/service/sortable', {
                        orders: list,
                    })
                    .then(function (response) {
                        Swal.fire({
                            title: 'موفق',
                            text: 'با موفقیت انجام شد',
                            icon: 'success'
                        })
                    })
                    .catch(function (error) {
                        Swal.fire({
                            title: 'خطا',
                            text: 'خطایی رخ داده است',
                            icon: 'error'
                        })
                    });

            },
        });






    </script>
@endsection

@section('content')
    <div class="card" style="margin-bottom:15px; ">

        <p class="demo-inline-spacing">
            <button type="button" class="btn btn-icon me-2 btn-primary" data-bs-toggle="collapse"
                data-bs-target=".multi-collapse" aria-expanded="false"
                aria-controls="multiCollapseExample1 multiCollapseExample2">
                <i class="bx bx-search bx-sm"></i>
            </button>


        </p>

        <section>
            <div class="row">

                <div class="row">
                    <div class="col-12 col-md-12">
                        <div class="collapse multi-collapse" id="multiCollapseExample2">
                            <div class="col-md-12" style="padding: 0.8%;">

                            </div>
                        </div>
                    </div>
                </div>



            </div>
        </section>
    </div>


    <div class="card">

            <div class="row">
                <div class="col-md-12 col-12 mb-md-0 mb-4">
                   @if(count($row_products) > 0 || count($row_ads) > 0 || count($row_news) > 0)
                        <ul class="list-group list-group-flush" id="clone-source-1">
                            @foreach($row_products as $item)
                                @if($item->products)
                                    <li class="list-group-item drag-item cursor-move d-flex justify-content-between align-items-center ">
                                        <div class="bulk-ids checkbox-primary m-r-15">
                                            <i class="fa fa-bars"></i>
                                            <input id="bulk-ids" onClick="syncItems(this)" name="ids[]" value="{{$item->id}}" type="checkbox">
                                            <label for="bulk-ids">{{$item->products->id}} - {{$item->products->title}}</label>
                                            <input style="display: none;" name="orders[]" value="{{$item->id}}">
                                        </div>
                                        <span class="badge">{{Verta($item->products->created_at)->format('Y-m-d h:i')}}</span>
                                    </li>
                                @endif

                            @endforeach
                                @foreach($row_news as $item)

                                    @if($item->news)
                                        <li class="list-group-item drag-item cursor-move d-flex justify-content-between align-items-center ">
                                            <div class="bulk-ids checkbox-primary m-r-15">
                                                <i class="fa fa-bars"></i>
                                                <input id="bulk-ids" onClick="syncItems(this)" name="ids[]" value="{{$item->id}}" type="checkbox">
                                                <label for="bulk-ids">{{$item->news->id}} - {{$item->news->title}}</label>
                                                <input style="display: none;" name="orders[]" value="{{$item->id}}">
                                            </div>
                                            <span class="badge">{{Verta($item->news->created_at)->format('Y-m-d h:i')}}</span>
                                        </li>
                                    @endif

                                @endforeach

                                @foreach($row_ads as $item)
                                                                    @if($item->ads)
                                        <li class="list-group-item drag-item cursor-move d-flex justify-content-between align-items-center ">
                                            <div class="bulk-ids checkbox-primary m-r-15">
                                                <i class="fa fa-bars"></i>
                                                <input id="bulk-ids" onClick="syncItems(this)" name="ids[]" value="{{$item->id}}" type="checkbox">
                                                <label for="bulk-ids">{{$item->ads->id}} - {{$item->ads->title}}</label>
                                                <input style="display: none;" name="orders[]" value="{{$item->id}}">
                                            </div>
                                            <span class="badge">{{Verta($item->ads->created_at)->format('Y-m-d h:i')}}</span>
                                        </li>
                                    @endif
                                @endforeach
                        </ul>
                       @else
                            <div class="alert alert-danger">
                                آیتمی ثبت نشده است
                            </div>
                       @endif
                </div>
            </div>





    </div>
@endsection
