<?php

namespace Modules\Site\app\Http\Controllers\Dashboard\Frest;




use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\Cache;
use Illuminate\Support\Facades\Session;
use Modules\Core\app\Http\Controllers\Helpers\File;
use Modules\Site\app\Http\Requests\Dashboard\Frest\Setting\SettingStoreRequest;
use Modules\Site\app\Http\Requests\Dashboard\Frest\Setting\SettingUpdateRequest;
use Modules\Site\app\Models\Setting;

class SettingController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        $this->authorize('controlpanel.access');
        $site = Request()->site_id;
        $settings = Setting::where('site_id',$site)->paginate();
        return view('site::Dashboard.Frest.setting.index',compact('settings','site'));
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        //
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(SettingStoreRequest $request)
    {

        $this->authorize('controlpanel.create');

        $file = File::uploadByFileManager($request->file);

        Setting::create([
            'title' => $request->title,
            'name' => $request->name,
            'state' => $request->state,
            'type' => $request->type,
            'value' => $request->value,
            'file' => $file,
            'site_id' => $request->site_id
        ]);

        session::flash('success','با موفقیت انجام شد');
        return redirect()->back();
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        //
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(SettingUpdateRequest $request,Setting $setting)
    {

        $this->authorize('controlpanel.edit');


        $file = File::uploadByFileManager($request->file);


        $setting->update([
            'title' => $request->title,
            'name' => $request->name,
            'state' => $request->state,
            'value' => $request->value,
            'file' => $file,
        ]);

        session::flash('success','با موفقیت انجام شد');
        return redirect()->back();
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy(Setting $setting)
    {
        $this->authorize('controlpanel.delete');
        $setting->delete();
        session::flash('success','با موفقیت انجام شد');
        return redirect()->back();
    }


    public function bulkAction()
    {

        $items = [];
        $items = explode(',',Request()->items);


        if(isset($_GET['delete']))
        {
            $this->authorize('controlpanel.delete');
            Setting::whereIn('id',$items)->delete();
        }
        if (isset($_GET['unPublish']))
        {
            $this->authorize('controlpanel.edit');
            Setting::whereIn('id',$items)->update([
                'state' => 0
            ]);
        }
        if(isset($_GET['publish']))
        {
            $this->authorize('controlpanel.edit');
            Setting::whereIn('id',$items)->update([
                'state' => 1
            ]);
        }


        Cache::forget('sites-' . config('app.template_site'));
        session::flash('success','با موفقیت انجام شد');
        return redirect()->back();

    }
}

