<?php

namespace Modules\Site\app\Http\Controllers\Dashboard\Frest;



use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\Cache;
use Illuminate\Support\Facades\Session;
use Illuminate\Validation\Rule;
use Modules\Core\app\Http\Controllers\Helpers\File;
use Modules\Site\app\Models\Site;

class SiteController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        $sites = Site::when(Request()->tran_id != null,function ($query){
                    $query->where('tran_id',Request()->tran_id);
                })
            ->when(Request()->tran_id == null,function ($query){
                $query->where('tran_id',null);
            })
            ->latest()->paginate(15);
        return view('site::Dashboard.Frest.site.index',compact('sites'));
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {

        $trans = Site::where('tran_id',Request()->tran_id)
            ->orWhere('id',Request()->tran_id)->pluck('lang')->toArray();

        return view('site::Dashboard.Frest.site.create',compact('trans'));
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {

        $this->validate($request, [
            'title' => 'required|max:100',
            'state' => 'required',
        ]);


        Site::create([
            'title' => $request->title,
            'logo' => $request->logo == null ? null :  File::uploadByFileManager($request->logo),
            'state' => $request->state,
            'lang' => $request->lang,
            'tran_id' => $request->tran_id,
            'meta_desc' => $request->meta_desc,
            'meta_tag' => $request->meta_tag,
            'type' => $request->type,
            'api_sender_sms' => $request->api_sender_sms,
            'api_token_sms' => $request->api_token_sms,
            'api_token_zarinpal' => $request->api_token_zarinpal,
        ]);

        Cache::forget('sites-' . config('app.template_site'));

        session::flash('success','با موفقیت انجام شد');
        return redirect()->route('admin.site.index');
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit(Site $site)
    {

        if($site->tran_id != null){
            $tran = Site::find($site->tran_id);
            $trans = $tran->translates->pluck('lang')->toArray();
            $trans[] = $tran->lang;
        } else {
            $trans = $site->translates->pluck('lang')->toArray();
        }



        return view('site::Dashboard.Frest.site.edit',compact('site','trans'));
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request,Site $site)
    {
        $this->validate($request, [
            'title' => 'required|max:100',
            'state' => 'required',
        ]);

        $site->title = $request->title;

        $site->logo = File::uploadByFileManager($request->logo,$site->logo);
        $site->state = $request->state;
        $site->meta_desc  = $request->meta_desc;
        $site->lang  = $request->lang;
        $site->meta_tag = $request->meta_tag;
        $site->type = $request->type;
        $site->api_sender_sms = $request->api_sender_sms;
        $site->api_token_sms = $request->api_token_sms;
        $site->api_token_zarinpal = $request->api_token_zarinpal;
        $site->update();

        Cache::forget('sites-' . config('app.template_site'));

        session::flash('success','با موفقیت انجام شد');
        return redirect()->route('admin.site.index');

    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy(Site $site)
    {

        $site->delete();

        Cache::forget('sites-' . config('app.template_site'));
        session::flash('success','با موفقیت انجام شد');
        return redirect()->route('admin.site.index');
    }



    public function bulkAction()
    {

        $items = [];
        $items = explode(',',Request()->items);


        if(isset($_GET['delete']))
        {
            $this->authorize('site.delete');
            Site::whereIn('id',$items)->delete();
        }
        if (isset($_GET['unPublish']))
        {
            $this->authorize('site.edit');
            Site::whereIn('id',$items)->update([
                'state' => 0
            ]);
        }
        if(isset($_GET['publish']))
        {
            $this->authorize('site.edit');
            Site::whereIn('id',$items)->update([
                'state' => 1
            ]);
        }


        Cache::forget('sites-' . config('app.template_site'));
        session::flash('success','با موفقیت انجام شد');
        return redirect()->back();

    }




}
