<?php

namespace Modules\Site\app\Http\Requests\Dashboard\Frest\Setting;


use Illuminate\Foundation\Http\FormRequest;

class SettingUpdateRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     *
     * @return bool
     */
    public function authorize()
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array
     */
    public function rules()
    {
        return [
            'title' => 'required|max:100',
            'name' => 'required|unique:settings,name,'.$this->route('setting')->id.',id,deleted_at,NULL',
            'value' => 'required|min:6',
        ];
    }
}

