<?php

namespace Modules\Site\app\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;
use Modules\Language\app\Models\Language;

class Site extends Model
{
    use SoftDeletes;

    protected $fillable = ['title','state' ,'type' ,'logo','meta_tag','meta_desc','lang','tran_id',        'api_sender_sms',
        'api_token_sms',
        'api_token_zarinpal'];

    protected $hidden = [
        'api_sender_sms',
        'api_token_sms',
        'api_token_zarinpal',
    ];

    public function settings(){
        return $this->hasMany(Setting::class,'site_id');
    }

    public function translates(){
        return $this->hasMany(Site::class,'tran_id','id');
    }
    public function language(){
        return $this->belongsTo(Language::class,'lang','name');
    }

    public function getLogoUrlAttribute($value){
        return  $this->logo;
    }

}
