<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateSitesTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('sites', function (Blueprint $table) {

            $table->id();
            $table->string('title');
            $table->string('logo')->nullable();
            $table->boolean('state')->default(0);
            $table->text('meta_tag')->nullable();
            $table->text('meta_desc')->nullable();
            $table->text('api_sender_sms')->nullable();
            $table->text('api_token_sms')->nullable();
            $table->text('api_token_zarinpal')->nullable();
            $table->softDeletes();
            $table->timestamps();

        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('sites');
    }
}
