@extends('core::Dashboard.Frest.Layouts.master')

@section('title')
   تنظیمات
@endsection

@section('style')
@endsection

@section('script')
    <script src="{{ asset('modules/core/js/modal-add-new-cc.js') }}"></script>
    <script src="{{ asset('modules/core/js/modal-add-new-address.js') }}"></script>
    <script src="{{ asset('modules/core/js/modal-edit-user.js') }}"></script>
    <script src="{{ asset('modules/core/js/modal-enable-otp.js') }}"></script>
@endsection

@section('content')


    <div class="modal fade" id="create-setting" data-bs-backdrop="static" tabindex="-1">
        <div class="modal-dialog">
            <form class="modal-content" action="{{route('admin.setting.store')}}" method="post">
                @csrf
                <div class="modal-header">
                    <h5 class="modal-title" id="backDropModalTitle">ایجاد تنظیمات</h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                </div>
                <div class="modal-body">

                    <input type="text" name="site_id" style="display: none;" required value="{{ $site }}">



                    <div class="row">

                        <div class="col-md-6">
                            <div class="form-group {{ $errors->has('title') ? 'has-errors' : '' }}">
                                <label for="field-1" class="control-label">عنوان</label>
                                <input type="text" name="title" required class="form-control" id="field-1" placeholder="عنوان" value="{{old('title')}}">
                                @if($errors->has('title'))
                                    <span class="help-doc text-danger">
                                        <strong>{{ $errors->first('title') }}</strong>
                                    </span>
                                @endif
                            </div>
                        </div>

                        <div class="col-md-6">
                            <div class="form-group {{ $errors->has('name') ? 'has-errors' : '' }}">
                                <label for="field-1" class="control-label">نام</label>
                                <input type="text" name="name" required class="form-control" id="field-1" placeholder="نام" value="{{old('name')}}">
                                @if($errors->has('name'))
                                    <span class="help-doc text-danger">
                                        <strong>{{ $errors->first('name') }}</strong>
                                    </span>
                                @endif
                            </div>
                        </div>

                        <div class="col-md-6 {{ $errors->has('type') ? 'has-errors' : '' }}">
                            <label for="field-2" class="control-label">نوع</label>
                            <select  name="type" required class="form-control" id="field-2"  >
                                <option value="image">تصویر</option>
                                <option value="text">متن</option>
                            </select>
                            @if($errors->has('type'))
                                <span class="help-doc text-danger">
                                        <strong>{{ $errors->first('type') }}</strong>
                                    </span>
                            @endif
                        </div>

                        <div class="col-md-6 {{ $errors->has('state') ? 'has-errors' : '' }}">
                            <label for="field-2" class="control-label">وضعیت</label>
                            <select  name="state" required class="form-control" id="field-2"  >
                                <option value="1">فعال</option>
                                <option value="0">غیر فعال</option>
                            </select>
                            @if($errors->has('state'))
                                <span class="help-doc text-danger">
                                        <strong>{{ $errors->first('state') }}</strong>
                                    </span>
                            @endif
                        </div>



                    </div>

                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-label-secondary" data-bs-dismiss="modal">بستن</button>
                    <button type="submit" class="btn btn-primary">ذخیره</button>
                </div>

            </form>
        </div>
    </div>


    <div class="card">
        <form action="{{ route('admin.bulk.settings') }}" method="get">
            <p class="demo-inline-spacing">
                <button type="button"  data-bs-toggle="modal" data-bs-target="#create-setting" class="btn btn-primary me-1">جدید</button>
                <button name="publish" type="submit" class="btn btn-success me-1">انتشار</button>
                <button name="unPublish" type="submit" class="btn btn-gray me-1">غیر انتشار</button>
                <button name="delete" type="submit" class="btn btn-danger me-1">حذف</button>
            </p>
            <input type="text" id="items" name="items" value="" style="display: none;">
        </form>

            <h5 class="card-header">تنظیمات</h5>
            <div class="table-responsive text-nowrap">
                <table class="table table-sm">
                    <thead>
                        <tr>
                            <th>
                                <div class="bulk-ids checkbox-primary m-r-15">
                                    <input id="bulk-ids" onClick="toggle(this)" type="checkbox">
                                    <label for="bulk-ids">#</label>
                                </div>
                            </th>
                            <th>عنوان</th>
                            <th>کلید</th>
                            <th>نوع</th>
                            <th>وضعیت انتشار</th>
                            <th>عملیات</th>
                        </tr>
                    </thead>
                    <tbody>

                        @foreach ($settings as $setting)


                            <tr >

                                <!-- Modal -->

                                <td>


                                    <div class="modal fade" id="update-setting-{{$setting->id}}" data-bs-backdrop="static" tabindex="-1">
                                        <div class="modal-dialog">
                                            <form class="modal-content" action="{{route('admin.setting.update',$setting->id)}}" method="post">
                                                @csrf
                                                @method('PATCH')
                                                <div class="modal-header">
                                                    <h5 class="modal-title" id="backDropModalTitle">ویرایش تنظیمات</h5>
                                                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                                                </div>
                                                <div class="modal-body">

                                                    <div class="row">

                                                        <div class="col-md-8">
                                                            <div class="form-group {{ $errors->has('title') ? 'has-errors' : '' }}">
                                                                <label for="field-1" class="control-label">عنوان</label>
                                                                <input type="text" name="title" required class="form-control" id="field-1" placeholder="عنوان" value="{{old('title',$setting->title)}}">
                                                                @if($errors->has('title'))
                                                                    <span class="help-doc text-danger">
                                        <strong>{{ $errors->first('title') }}</strong>
                                    </span>
                                                                @endif
                                                            </div>
                                                        </div>

                                                        <div class="col-md-6">
                                                            <div class="form-group {{ $errors->has('name') ? 'has-errors' : '' }}">
                                                                <label for="field-1" class="control-label">نام</label>
                                                                <input type="text" name="name" required class="form-control" id="field-1" placeholder="نام" value="{{old('name',$setting->name)}}">
                                                                @if($errors->has('name'))
                                                                    <span class="help-doc text-danger">
                                        <strong>{{ $errors->first('name') }}</strong>
                                    </span>
                                                                @endif
                                                            </div>
                                                        </div>

                                                        <div class="col-md-6 {{ $errors->has('state') ? 'has-errors' : '' }}">
                                                            <label for="field-2" class="control-label">وضعیت</label>
                                                            <select  name="state" required class="form-control" id="field-2"  >
                                                                <option value="1" {{$setting->state == 1 ? 'selected' : ''}}>فعال</option>
                                                                <option value="0" {{$setting->state == 0 ? 'selected' : ''}}>غیر فعال</option>
                                                            </select>
                                                            @if($errors->has('state'))
                                                                <span class="help-doc text-danger">
                                        <strong>{{ $errors->first('state') }}</strong>
                                    </span>
                                                            @endif
                                                        </div>

                                                        @if($setting->type == 'image')


                                                            <div class="col-md-12">
                                                                <label class="form-label" for="title">فایل</label>
                                                                <div class="input-group">
                                                                    <input type="text" id="image1" class="form-control" name="value"
                                                                           aria-label="Image" aria-describedby="button-image">
                                                                    <div class="input-group-append">
                                                                        <button class="btn btn-outline-secondary" type="button" id="button-image">آپلود</button>
                                                                    </div>
                                                                </div>
                                                            </div>


                                                        @endif


                                                        @if($setting->type == 'text')


                                                            <div class="col-md-12">
                                                                <label class="form-label">مقدار</label>
                                                                <input type="text" name="value" required class="form-control" id="field-1" placeholder="مقدار" value="{{old('value',$setting->value)}}">
                                                                @if($errors->has('value'))
                                                                    <span class="help-doc text-danger">
                                                                    <strong>{{ $errors->first('value') }}</strong>
                                                                </span>
                                                                @endif
                                                            </div>


                                                        @endif



                                                    </div>

                                                </div>
                                                <div class="modal-footer">
                                                    <button type="button" class="btn btn-label-secondary" data-bs-dismiss="modal">بستن</button>
                                                    <button type="submit" class="btn btn-primary">ذخیره</button>
                                                </div>
                                            </form>
                                        </div>
                                    </div>

                                    <div class="bulk-ids checkbox-primary m-r-15">
                                        <input id="bulk-ids" onClick="syncItems(this)" name="ids[]" value="{{$setting->id}}" type="checkbox">
                                        <label for="bulk-ids">{{$setting->id}}</label>
                                    </div>
                                </td>
                                <td> {{ $setting->title }}</td>
                                <td> {{$setting->name}}</td>

                                @if($setting->type == 'image')
                                    <td><span class="badge bg-label-success me-1">تصویر</span></td>
                                @endif
                                @if($setting->type == 'text')
                                    <td><span class="badge bg-label-danger me-1">متن</span></td>
                                @endif

                                @if($setting->state == 1)
                                    <td><span class="badge bg-label-success me-1">فعال</span></td>
                                @endif
                                @if($setting->state == 0)
                                    <td><span class="badge bg-label-danger me-1">غیرفعال</span></td>
                                @endif


                                <td>
                                    <div class="dropdown">
                                        <button type="button" class="btn p-0 dropdown-toggle hide-arrow" data-bs-toggle="dropdown"><i class="bx bx-dots-vertical-rounded"></i></button>
                                        <div class="dropdown-menu">
                                            <a class="dropdown-item" data-bs-toggle="modal" data-bs-target="#update-setting-{{$setting->id}}"><i class="bx bx-edit-alt me-1"></i>ویرایش</a>

                                            <button class="dropdown-item" onclick="event.preventDefault();confirmDelete('delete-{{$setting->id}}')"><i class="bx bx-trash me-1"></i>حذف</button>
                                            <form id="delete-{{$setting->id}}" action="{{ route('admin.setting.destroy', $setting->id) }}" method="POST" style="display: none;">
                                                {{ csrf_field() }}
                                                {{ method_field('DELETE') }}
                                            </form>
                                        </div>
                                    </div>
                                </td>


                            </tr>


                        @endforeach

                    </tbody>
                </table>

                <div style="margin-top: 10%;">
                    {{ $settings->render() }}
                </div>

            </div>





    </div>
@endsection
