@extends('core::Dashboard.Frest.Layouts.master')

@section('title')ایجاد سایت@endsection

    @section('style')
        <link rel="stylesheet" href="{{asset('modules/core/vendor/libs/tagify/tagify.css')}}" />
        @endsection

    @section('script')
        <script src="{{asset('modules/core/js/pages-account-settings-account.js')}}"></script>
    @endsection

@section('content')

    <div class="container-xxl flex-grow-1 container-p-y">
        <div class="row">
            <div class="col-md-12">
                <ul class="nav nav-pills flex-column flex-md-row mb-3">
                    <li class="nav-item">
                        <a class="nav-link active" href="javascript:void(0);"><i class="bx bx-user me-1"></i> ایجاد سایت</a>
                    </li>

                </ul>
                <div class="card mb-4">
                    <h5 class="card-header">{{\Modules\Core\app\Http\Controllers\Helpers\Str::getTitleBoard("ویرایش سایت")}}</h5>
                    <!-- Account -->
                    <hr class="my-0">
                    <div class="card-body">

                        <form id="save" action="{{route('admin.site.update',$site->id)}}" method="post">
                            {{ csrf_field() }}
                            @method('PUT')
                            <div class="tab-pane fade active show" id="tab1" role="tabpanel">


                                <div class="row g-3">

                                    <div class="col-md-8">

                                        <div class="row">

                                            <div class="col-md-6">
                                                <span>*</span>
                                                <label class="form-label" for="title">عنوان</label>
                                                <input type="text" id="title"  name="title" class="form-control" placeholder="عنوان" value="{{$site->title}}">
                                                @if($errors->has('title'))
                                                    <div data-field="title" class="text-danger">{{ $errors->first('title') }}</div>
                                                @endif
                                            </div>

                                            <div class="col-md-6">
                                                <span>*</span>
                                                <label class="form-label" for="type">نوع سایت</label>
                                                <div class="position-relative">
                                                    <select id="type" name="type" class="form-select" >
                                                        <option value="news" {{$site->type == 'news' ? 'selected' : ''}} >خبری</option>
                                                        <option value="shop" {{$site->type == 'shop' ? 'selected' : ''}} >فروشگاهی</option>
                                                        <option value="personal" {{$site->type == 'personal' ? 'selected' : ''}} >شخصی</option>
                                                        <option value="company" {{$site->type == 'company' ? 'selected' : ''}} >شرکتی</option>
                                                    </select>
                                                </div>
                                            </div>



                                            <div class="col-md-12">
                                                <label for="meta_tag" class="form-label">متا تگ</label>
                                                <input id="meta_tag" class="form-control" name="meta_tag" value="{{$site->meta_tag}}" />
                                                @if($errors->has('meta_tag'))
                                                    <div data-field="title" class="text-danger">{{ $errors->first('meta_tag') }}</div>
                                                @endif
                                            </div>


                                            <div  class="col-md-12">
                                                <label for="meta_desc" class="form-label">توضیحات متا</label>
                                                <textarea id="meta_desc" class="form-control" name="meta_desc">{{$site->meta_desc}}</textarea>
                                                @if($errors->has('meta_desc'))
                                                    <div data-field="title" class="text-danger">{{ $errors->first('meta_desc') }}</div>
                                                @endif
                                            </div>

                                            <div  class="col-md-12">
                                                <label for="api_sender_sms" class="form-label">شماره فرستنده درگاه پیامک</label>
                                                <input id="api_sender_sms" class="form-control" name="api_sender_sms"  value="{{$site->api_sender_sms}}"/>
                                                @if($errors->has('api_sender_sms'))
                                                    <div data-field="title" class="text-danger">{{ $errors->first('api_sender_sms') }}</div>
                                                @endif
                                            </div>
                                            <div  class="col-md-12">
                                                <label for="api_token_sms" class="form-label">کلید درگاه پیامک</label>
                                                <input id="api_token_sms" class="form-control" name="api_token_sms"  value="{{$site->api_token_sms}}"/>
                                                @if($errors->has('api_token_sms'))
                                                    <div data-field="title" class="text-danger">{{ $errors->first('api_token_sms') }}</div>
                                                @endif
                                            </div>
                                            <div  class="col-md-12">
                                                <label for="api_token_zarinpal" class="form-label">کلید درگاه زرین پال</label>
                                                <input id="api_token_zarinpal" class="form-control" name="api_token_zarinpal" value="{{$site->api_token_zarinpal}}" />
                                                @if($errors->has('api_token_zarinpal'))
                                                    <div data-field="title" class="text-danger">{{ $errors->first('api_token_zarinpal') }}</div>
                                                @endif
                                            </div>


                                        </div>

                                    </div>

                                    <div class="col-md-4">

                                        <div class="row">

                                            <div class="col-md-12">
                                                <span>*</span>
                                                <label class="form-label" for="state">وضعیت</label>
                                                <div class="position-relative">
                                                    <select required id="state" name="state" class="form-select" >
                                                        <option value="1" {{'1' == $site->state ? 'selected' : ''}}>فعال</option>
                                                        <option value="0" {{'0' == $site->state ? 'selected' : ''}}>غیر فعال</option>
                                                    </select>
                                                </div>
                                            </div>

                                            <div class="col-md-12">
                                                <span>*</span>
                                                <label class="form-label" for="state">زبان</label>
                                                <div class="position-relative">
                                                    <select required id="lang" name="lang" class="form-select" >
                                                        @foreach($languages as $language)
                                                            @if(!in_array($language->name,$trans) || $language->name == $site->lang)
                                                            <option value="{{$language->name}}" {{$language->name == $site->lang ? 'selected' : ''}}>
                                                                {{$language->title}}</option>
                                                            @endif
                                                        @endforeach
                                                    </select>
                                                </div>
                                            </div>



                                            <div class="col-md-12">
                                                <label class="form-label" for="title">لوگو</label>
                                                <div class="input-group">
                                                    <input type="text" id="image1" class="form-control" name="logo"
                                                           aria-label="Image" aria-describedby="button-image">
                                                    <div class="input-group-append">
                                                        <button class="btn btn-outline-secondary" type="button" id="button-image">آپلود</button>
                                                    </div>
                                                </div>
                                            </div>




                                        </div>

                                    </div>

                                </div>


                            </div>

                            <div class="pt-4">
                                <button type="submit" name="save" class="btn btn-primary me-sm-3 me-1">ثبت</button>
                                <a href="{{route('admin.site.index')}}" type="reset" class="btn btn-label-secondary">انصراف</a>
                            </div>

                        </form>




                    </div>
                    <!-- /Account -->
                </div>

            </div>
        </div>
    </div>

@endsection
