<?php

namespace Modules\Tag\app\Models;

use Illuminate\Database\Eloquent\Model;
use Modules\News\app\Models\News;
use Modules\Product\app\Models\Product;

class Tag extends Model
{
    protected $fillable = ['name'];
    public function tags()
    {
        return $this->morphedByMany(Tag::class, 'taggable');
    }

    public function products()
    {
        return $this->morphedByMany(Product::class, 'taggable');
    }

    public function posts()
    {
        return $this->morphedByMany(News::class, 'taggable');
    }

    public function getRouteAttribute(){
        return "/news?tags=".$this->name;
    }

}
