<?php

namespace Modules\Template\app\Http\Controllers\Dashboard\Frest;




use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Session;
use Modules\Core\app\Http\Controllers\Helpers\File;
use Modules\Template\app\Models\Template;
use Modules\Template\app\Http\Requests\Dashboard\Frest\Template\TemplateStoreRequest;
use Modules\Template\app\Http\Requests\Dashboard\Frest\Template\TemplateUpdateRequest;


class TemplateController extends Controller
{


    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {


       $this->authorize('template.access');

        $templates = Template::latest()->paginate();




        return view('template::Dashboard.Frest.template.index',compact('templates'));
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
      //
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(TemplateStoreRequest $request)
    {

        $this->authorize('template.create');

        if($request->state == 1){
            DB::table('templates')
                ->where('type',$request->type)
                ->update(array('state' => 0));
        }

        Template::create([
            'title' => $request->title,
            'name' => $request->name,
            'state' => $request->state,
            'type' => $request->type,
        ]);

        session::flash('success','با موفقیت انجام شد');
        return redirect()->back();
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
       //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
      //
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(TemplateUpdateRequest $request,Template $template)
    {

        $this->authorize('template.edit');

        if($request->state == 1){
            DB::table('templates')
                ->where('type',$request->type)
                ->update(array('state' => 0));
        }

        $template->update([
            'title' => $request->title,
            'name' => $request->name,
            'state' => $request->state,
            'type' => $request->type,
        ]);

        session::flash('success','با موفقیت انجام شد');
        return redirect()->back();
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy(Template $template)
    {
        $this->authorize('template.delete');
        $template->delete();
        session::flash('success','با موفقیت انجام شد');
        return redirect()->back();
    }


    public function bulkAction()
    {

        $items = [];
        $items = explode(',',Request()->items);


        if(isset($_GET['delete']))
        {
            $this->authorize('template.delete');
            Template::whereIn('id',$items)->delete();
        }
        if (isset($_GET['unPublish']))
        {
            $this->authorize('template.edit');
            Template::whereIn('id',$items)->update([
                'state' => 0
            ]);
        }
        if(isset($_GET['publish']))
        {
            $this->authorize('template.edit');
            Template::whereIn('id',$items)->update([
                'state' => 1
            ]);
        }



        session::flash('success','با موفقیت انجام شد');
        return redirect()->back();

    }
}

