@extends('core::Dashboard.Frest.Layouts.master')

@section('title')
   قالب ها
@endsection

@section('style')
@endsection

@section('script')
    <script src="{{ asset('modules/core/js/modal-add-new-cc.js') }}"></script>
    <script src="{{ asset('modules/core/js/modal-add-new-address.js') }}"></script>
    <script src="{{ asset('modules/core/js/modal-edit-user.js') }}"></script>
    <script src="{{ asset('modules/core/js/modal-enable-otp.js') }}"></script>
@endsection

@section('content')


    <div class="modal fade" id="create-template" data-bs-backdrop="static" tabindex="-1">
        <div class="modal-dialog">
            <form class="modal-content" action="{{route('admin.template.store')}}" method="post">
                @csrf
                <div class="modal-header">
                    <h5 class="modal-title" id="backDropModalTitle">ایجاد قالب</h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                </div>
                <div class="modal-body">



                    <div class="row">

                        <div class="col-md-6">
                            <div class="form-group {{ $errors->has('title') ? 'has-errors' : '' }}">
                                <label for="field-1" class="control-label">عنوان</label>
                                <input type="text" name="title" required class="form-control" id="field-1" placeholder="عنوان" value="{{old('title')}}">
                                @if($errors->has('title'))
                                    <span class="help-doc text-danger">
                                        <strong>{{ $errors->first('title') }}</strong>
                                    </span>
                                @endif
                            </div>
                        </div>

                        <div class="col-md-6">
                            <div class="form-group {{ $errors->has('name') ? 'has-errors' : '' }}">
                                <label for="field-1" class="control-label">نام</label>
                                <input type="text" name="name" required class="form-control" id="field-1" placeholder="نام" value="{{old('name')}}">
                                @if($errors->has('name'))
                                    <span class="help-doc text-danger">
                                        <strong>{{ $errors->first('name') }}</strong>
                                    </span>
                                @endif
                            </div>
                        </div>


                        <div class="col-md-6 {{ $errors->has('state') ? 'has-errors' : '' }}">
                            <label for="field-2" class="control-label">وضعیت</label>
                            <select  name="state" required class="form-control" id="field-2"  >
                                <option value="1">فعال</option>
                                <option value="0">غیر فعال</option>
                            </select>
                            @if($errors->has('state'))
                                <span class="help-doc text-danger">
                                        <strong>{{ $errors->first('state') }}</strong>
                                    </span>
                            @endif
                        </div>

                        <div class="col-md-6 {{ $errors->has('type') ? 'has-errors' : '' }}">
                            <label for="field-2" class="control-label">وضعیت</label>
                            <select  name="type" required class="form-control" id="field-2"  >
                                <option value="admin">مدیریت</option>
                                <option value="site" >سایت</option>
                            </select>
                            @if($errors->has('type'))
                                <span class="help-doc text-danger">
                                        <strong>{{ $errors->first('type') }}</strong>
                                    </span>
                            @endif
                        </div>



                    </div>

                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-label-secondary" data-bs-dismiss="modal">بستن</button>
                    <button type="submit" class="btn btn-primary">ذخیره</button>
                </div>

            </form>
        </div>
    </div>


    <div class="card">
        <form action="{{ route('admin.bulk.templates') }}" method="get">
            <p class="demo-inline-spacing">
                <button type="button"  data-bs-toggle="modal" data-bs-target="#create-template" class="btn btn-primary me-1">جدید</button>
                <button name="publish" type="submit" class="btn btn-success me-1">انتشار</button>
                <button name="unPublish" type="submit" class="btn btn-gray me-1">غیر انتشار</button>
                <button name="delete" type="submit" class="btn btn-danger me-1">حذف</button>
            </p>
            <input type="text" id="items" name="items" value="" style="display: none;">
        </form>

            <h5 class="card-header">قالب ها</h5>
            <div class="table-responsive text-nowrap">
                <table class="table table-sm">
                    <thead>
                        <tr>
                            <th>
                                <div class="bulk-ids checkbox-primary m-r-15">
                                    <input id="bulk-ids" onClick="toggle(this)" type="checkbox">
                                    <label for="bulk-ids">#</label>
                                </div>
                            </th>
                            <th>عنوان</th>
                            <th>کلید</th>
                            <th>عملیات</th>
                        </tr>
                    </thead>
                    <tbody>

                        @foreach ($templates as $template)


                            <tr >

                                <!-- Modal -->

                                <td>


                                    <div class="modal fade" id="update-template-{{$template->id}}" data-bs-backdrop="static" tabindex="-1">
                                        <div class="modal-dialog">
                                            <form class="modal-content" action="{{route('admin.template.update',$template->id)}}" method="post">
                                                @csrf
                                                @method('PATCH')
                                                <div class="modal-header">
                                                    <h5 class="modal-title" id="backDropModalTitle">ویرایش قالب ها</h5>
                                                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                                                </div>
                                                <div class="modal-body">

                                                    <div class="row">

                                                        <div class="col-md-8">
                                                            <div class="form-group {{ $errors->has('title') ? 'has-errors' : '' }}">
                                                                <label for="field-1" class="control-label">عنوان</label>
                                                                <input type="text" name="title" required class="form-control" id="field-1" placeholder="عنوان" value="{{old('title',$template->title)}}">
                                                                @if($errors->has('title'))
                                                                    <span class="help-doc text-danger">
                                        <strong>{{ $errors->first('title') }}</strong>
                                    </span>
                                                                @endif
                                                            </div>
                                                        </div>

                                                        <div class="col-md-6">
                                                            <div class="form-group {{ $errors->has('name') ? 'has-errors' : '' }}">
                                                                <label for="field-1" class="control-label">نام</label>
                                                                <input type="text" name="name" required class="form-control" id="field-1" placeholder="نام" value="{{old('name',$template->name)}}">
                                                                @if($errors->has('name'))
                                                                    <span class="help-doc text-danger">
                                        <strong>{{ $errors->first('name') }}</strong>
                                    </span>
                                                                @endif
                                                            </div>
                                                        </div>

                                                        <div class="col-md-6 {{ $errors->has('state') ? 'has-errors' : '' }}">
                                                            <label for="field-2" class="control-label">وضعیت</label>
                                                            <select  name="state" required class="form-control" id="field-2"  >
                                                                <option value="1" {{$template->state == 1 ? 'selected' : ''}}>فعال</option>
                                                                <option value="0" {{$template->state == 0 ? 'selected' : ''}}>غیر فعال</option>
                                                            </select>
                                                            @if($errors->has('state'))
                                                                <span class="help-doc text-danger">
                                        <strong>{{ $errors->first('state') }}</strong>
                                    </span>
                                                            @endif
                                                        </div>


                                                        <div class="col-md-6 {{ $errors->has('type') ? 'has-errors' : '' }}">
                                                            <label for="field-2" class="control-label">وضعیت</label>
                                                            <select  name="type" required class="form-control" id="field-2"  >
                                                                <option value="admin" {{$template->type == "admin" ? 'selected' : ''}}>مدیریت</option>
                                                                <option value="site" {{$template->type == "site" ? 'selected' : ''}}>سایت</option>
                                                            </select>
                                                            @if($errors->has('type'))
                                                                <span class="help-doc text-danger">
                                        <strong>{{ $errors->first('type') }}</strong>
                                    </span>
                                                            @endif
                                                        </div>








                                                    </div>

                                                </div>
                                                <div class="modal-footer">
                                                    <button type="button" class="btn btn-label-secondary" data-bs-dismiss="modal">بستن</button>
                                                    <button type="submit" class="btn btn-primary">ذخیره</button>
                                                </div>
                                            </form>
                                        </div>
                                    </div>

                                    <div class="bulk-ids checkbox-primary m-r-15">
                                        <input id="bulk-ids" onClick="syncItems(this)" name="ids[]" value="{{$template->id}}" type="checkbox">
                                        <label for="bulk-ids">{{$template->id}}</label>
                                    </div>
                                </td>
                                <td> {{ $template->title }}</td>
                                <td> {{$template->name}}</td>

                                @if($template->state == 1)
                                    <td><span class="badge bg-label-success me-1">فعال</span></td>
                                @endif
                                @if($template->state == 0)
                                    <td><span class="badge bg-label-danger me-1">غیرفعال</span></td>
                                @endif

                                @if($template->type == 'admin')
                                    <td><span class="badge bg-label-success me-1">مدیریت</span></td>
                                @endif
                                @if($template->type == 'site')
                                    <td><span class="badge bg-label-danger me-1">سایت</span></td>
                                @endif

                                <td>
                                    <div class="dropdown">
                                        <button type="button" class="btn p-0 dropdown-toggle hide-arrow" data-bs-toggle="dropdown"><i class="bx bx-dots-vertical-rounded"></i></button>
                                        <div class="dropdown-menu">
                                            <a class="dropdown-item" data-bs-toggle="modal" data-bs-target="#update-template-{{$template->id}}"><i class="bx bx-edit-alt me-1"></i>ویرایش</a>

                                            <button class="dropdown-item" onclick="event.preventDefault();confirmDelete('delete-{{$template->id}}')"><i class="bx bx-trash me-1"></i>حذف</button>
                                            <form id="delete-{{$template->id}}" action="{{ route('admin.template.destroy', $template->id) }}" method="POST" style="display: none;">
                                                {{ csrf_field() }}
                                                {{ method_field('DELETE') }}
                                            </form>
                                        </div>
                                    </div>
                                </td>


                            </tr>


                        @endforeach

                    </tbody>
                </table>

                <div style="margin-top: 10%;">
                    {{ $templates->render() }}
                </div>

            </div>





    </div>
@endsection
