<?php

namespace Modules\User\app\Http\Controllers\Dashboard\Frest;

use App\Http\Controllers\Controller;
use Illuminate\Http\RedirectResponse;
use Illuminate\Http\Request;
use Illuminate\Http\Response;
use Modules\User\app\Http\Requests\Dashboard\Frest\Education\EducationStorRequest;
use Modules\User\app\Http\Requests\Dashboard\Frest\Education\EducationUpdateRequest;
use Modules\User\app\Models\Education;
use Illuminate\Support\Facades\Session;
class EducationController extends Controller
{
    public function index()
    {
        $educations = Education::all();
        $query = Education::when(!is_null(Request()->q),function ($query){
                return $query->where('title','LIKE','%'.Request()->q."%")
                    ->orWhere('id','LIKE','%'.Request()->q."%");
            })
            ->latest('id');

        return view('user::Dashboard.Frest.education.index', compact('educations'));
    }

    public function create()
    {
        return view('user::Dashboard.Frest.education.create');
    }

    public function store(EducationStorRequest $request)
    {
        $category = Education::create([
            'title' => $request->title,
            'name' => $request->name,
            'state' => $request->state,
        ]);

        session::flash('success','با موفقیت انجام شد');
        return redirect()->route('admin.education.index');
    }

    public function show($id)
    {
        return view('user::show');
    }

    public function edit($id)
    {
        $education = Education::where('id', $id)->first();
        return view('user::Dashboard.Frest.education.edit', compact('education'));
    }

    public function update(EducationUpdateRequest $request, Education $education)
    {
        $education->title = $request->title;
        $education->name = $request->name;
        $education->state = $request->state;
        $education->update();

        Session::flash('success','با موفقیت انجام شد');
        return redirect()->route('admin.education.index');
    }

    public function destroy(Education $education)
    {
        $education->delete();

        Session::flash('success','با موفقیت انجام شد');
        return redirect()->back();
    }

    public function bulkAction()
    {

        $items = [];
        $items = explode(',',Request()->items);

        if(isset($_GET['delete']))
        {
//            $this->authorize('education.delete');
            Education::whereIn('id',$items)->delete();
        }
        if (isset($_GET['unPublish']))
        {
//            $this->authorize('product.edit');
            Education::whereIn('id',$items)->update([
                'state' => 0
            ]);
        }
        if(isset($_GET['publish']))
        {
//            $this->authorize('product.edit');
            Education::whereIn('id',$items)->update([
                'state' => 1
            ]);
        }

        session::flash('success','با موفقیت انجام شد');
        return redirect()->back();

    }

}
