<?php

namespace Modules\User\app\Http\Controllers\Dashboard\Frest;

use App\Http\Controllers\Controller;
use Illuminate\Http\RedirectResponse;
use Illuminate\Http\Request;
use Illuminate\Http\Response;
use Illuminate\Support\Facades\Session;
use Modules\User\app\Http\Requests\Dashboard\Frest\Major\MajorStorRequest;
use Modules\User\app\Http\Requests\Dashboard\Frest\Major\MajorUpdateRequest;
use Modules\User\app\Models\Education;
use Modules\User\app\Models\Major;

class MajorController extends Controller
{
    public function index()
    {
        $majors = Major::all();
        return view('user::Dashboard.Frest.major.index', compact('majors'));
    }

    public function create()
    {
        return view('user::Dashboard.Frest.major.create');
    }

    public function store(MajorStorRequest $request)
    {
        $major = Major::create([
            'title' => $request->title,
            'name' => $request->name,
            'state' => $request->state,
        ]);

        session::flash('success','با موفقیت انجام شد');
        return redirect()->route('admin.major.index');
    }

    public function show($id)
    {
//        return view('user::show');
    }

    public function edit($id)
    {
        $major = Major::where('id', $id)->first();
        return view('user::Dashboard.Frest.major.edit', compact('major'));
    }

    public function update(MajorUpdateRequest $request, Major $major)
    {
        $major->title = $request->title;
        $major->name = $request->name;
        $major->state = $request->state;
        $major->update();

        Session::flash('success','با موفقیت انجام شد');
        return redirect()->route('admin.major.index');
    }

    public function destroy(Major $major)
    {
        $major->delete();

        Session::flash('success','با موفقیت انجام شد');
        return redirect()->back();
    }

    public function bulkAction()
    {

        $items = [];
        $items = explode(',',Request()->items);

        if(isset($_GET['delete']))
        {
//            $this->authorize('education.delete');
            Major::whereIn('id',$items)->delete();
        }
        if (isset($_GET['unPublish']))
        {
//            $this->authorize('product.edit');
            Major::whereIn('id',$items)->update([
                'state' => 0
            ]);
        }
        if(isset($_GET['publish']))
        {
//            $this->authorize('product.edit');
            Major::whereIn('id',$items)->update([
                'state' => 1
            ]);
        }

        session::flash('success','با موفقیت انجام شد');
        return redirect()->back();

    }

}
