<?php

namespace Modules\User\app\Http\Controllers\Dashboard\Frest;

use App\Http\Controllers\Controller;
use Carbon\Carbon;
use Illuminate\Http\RedirectResponse;
use Illuminate\Http\Request;
use Illuminate\Http\Response;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Session;
use Modules\Area\app\Models\City;
use Modules\Area\app\Models\Province;
use Modules\Core\app\Http\Controllers\Helpers\File;
use Modules\Message\app\Models\Message;
use Modules\User\app\Http\Requests\Dashboard\Frest\User\UserStorRequest;
use Modules\User\app\Http\Requests\Dashboard\Frest\User\UserUpdateRequest;
use Modules\User\app\Models\Education;
use Modules\User\app\Models\Major;
use Modules\User\app\Models\Position;
use Modules\User\app\Models\Profile;
use Modules\User\app\Models\User;
use Modules\User\app\Models\UsersGallery;
use Illuminate\Support\Facades\Storage;
use Modules\Vehicle\app\Models\VehicleGallery;
use Modules\Vehicle\app\Models\Vehicles;
use Morilog\Jalali\Jalalian;

class UserController extends Controller
{
    public function index()
    {
        $users = User::with('profile.education', 'profile.major', 'profile.position')->get();

        $majors = Major::where('state', 1)->get();
        $educations = Education::where('state', 1)->get();
        $position = Position::all();

        return view('user::Dashboard.Frest.user.index', compact('users', 'majors', 'educations', 'position'));
    }

    public function create()
    {
        $position = Position::all();
        $majors = Major::where('state', 1)->get();
        $educations = Education::where('state', 1)->get();
        $cities =  City::where('status', 1)->get();
        $provinces = Province::where('status', 1)->get();
        $positions = Position::all();
        return view('user::Dashboard.Frest.user.create', compact('majors', 'educations', 'position', 'cities', 'provinces', 'positions'));
    }
    public function store(UserStorRequest $request)
    {
        $national_card = File::imageUpload($request->national_card, 'users', $width = null, $height = null, $disk = 'secret');
        $certificate_card = File::imageUpload($request->certificate_card, 'users', $width = null, $height = null, $disk = 'secret');
        $personal_photo = File::imageUpload($request->personal_photo, 'users', $width = null, $height = null, $disk = 'secret');
        $passport = File::imageUpload($request->passport, 'users', $width = null, $height = null, $disk = 'secret');
        $licence = File::imageUpload($request->licence, 'users', $width = null, $height = null, $disk = 'secret');

        $user = User::create([
            'mobile' => $request->mobile,
            'state' => 'pending',
        ]);

        $dateTime = Carbon::createFromFormat('Y-m-d H:i', $request->birth_date);
        $dateOnly = $dateTime->format('Y-m-d');
        $jalalian = Jalalian::fromFormat('Y-m-d', $dateOnly);
        $birth_date = $jalalian->toCarbon()->format('Y-m-d');
        $profile = Profile::create([
            'first_name' => $request->firstname,
            'last_name' => $request->lastname,
            'latin_first_name' => $request->latin_firstname,
            'latin_last_name' => $request->latin_lastname,
            'father_name' => $request->father_name,
            'latin_father_name' => $request->latin_father_name,
            'certificate_number' => $request->certificate_number,
            'gender' => $request->gender,
            'city_id' => $request->city_id,
            'province_id' => $request->province_id,
            'blood_type' => $request->blood_type,
            'position_id' => $request->position_id,
            'postal_code' => $request->postal_code,
            'postal_address' => $request->postal_address,
            'birth_date' => $birth_date,
            'user_id' => $user->id,
            'major_id' => $request->major_id,
            'education_id' => $request->education_id,
        ]);


        $createUserGallery = UsersGallery::create([
            'name' => 'national_card',
            'path_file' => $national_card,
            'user_id' => $user->id,
        ]);

        $createUserGallery = UsersGallery::create([
            'name' => 'certificate_card',
            'path_file' => $certificate_card,
            'user_id' => $user->id,
        ]);

        $createUserGallery = UsersGallery::create([
            'name' => 'personal_photo',
            'path_file' => $personal_photo,
            'user_id' => $user->id,
        ]);

        $createUserGallery = UsersGallery::create([
            'name' => 'passport',
            'path_file' => $passport,
            'user_id' => $user->id,
        ]);

        $createUserGallery = UsersGallery::create([
            'name' => 'licence',
            'path_file' => $licence,
            'user_id' => $user->id,
        ]);

        session::flash('success','با موفقیت انجام شد');
        return redirect()->route('admin.user.index');
    }
    public function show($id)
    {
        $gallery = UsersGallery::find($id);
        return Storage::disk('secret')->response($gallery->path_file);
    }
    public function edit($id)
    {
        $cities =  City::where('status', 1)->get();
        $provinces = Province::where('status', 1)->get();
        $positions = Position::all();
        $majors = Major::where('state', 1)->get();
        $educations = Education::where('state', 1)->get();
        $user = User::with('profile.education','galleries' ,'notes','profile.major')->find($id);
        if ($user->profile != null)
        {
            $carbonDate = Carbon::parse($user->profile->birth_date); // تبدیل به Carbon
            $user->profile->birth_date = Jalalian::fromCarbon($carbonDate)->format('Y/m/d');
        }
        return view('user::Dashboard.Frest.user.edit', compact('majors', 'educations', 'user', 'positions', 'cities', 'provinces'));
    }
    public function update(UserUpdateRequest $request, User $user)
    {
        $old_user_galleries = UsersGallery::where('user_id', $user->id)->get();

        $national_card = $old_user_galleries[0]->path_file;
        $certificate_card = $old_user_galleries[1]->path_file;
        $personal_photo = $old_user_galleries[2]->path_file;
        $passport = $old_user_galleries[3]->path_file;
        $licence = $old_user_galleries[4]->path_file;

        if (isset($request->national_card))
        {
            $national_card_delete = File::delete($national_card, $disk = 'secret');
            $national_card = File::uploadImage($request->national_card, 'users', $width = null, $height = null, $disk = 'secret');
            $updateUserGallery = UsersGallery::where('name', 'national_card')->where('user_id', $user->id)->update([
                'name' => 'national_card',
                'path_file' => $national_card,
                'user_id' => $user->id,
            ]);
        }
        if (isset($request->certificate_card))
        {
            $certificate_card_delete = File::delete($certificate_card, $disk = 'secret');
            $certificate_card = File::uploadImage($request->certificate_card, 'users', $width = null, $height = null, $disk = 'secret');
            $updateUserGallery = UsersGallery::where('name', 'certificate_card')->where('user_id', $user->id)->update([
                'name' => 'certificate_card',
                'path_file' => $certificate_card,
                'user_id' => $user->id,
            ]);
        }
        if (isset($request->personal_photo))
        {
            $personal_photo_delete = File::delete($personal_photo, $disk = 'secret');
            $personal_photo = File::uploadImage($request->personal_photo, 'users', $width = null, $height = null, $disk = 'secret');
            $updateUserGallery = UsersGallery::where('name', 'personal_photo')->where('user_id', $user->id)->update([
                'name' => 'personal_photo',
                'path_file' => $personal_photo,
                'user_id' => $user->id,
            ]);
        }
        if (isset($request->passport))
        {
            $passport_delete = File::delete($passport, $disk = 'secret');
            $passport = File::uploadImage($request->passport, 'users', $width = null, $height = null, $disk = 'secret');
            $updateUserGallery = UsersGallery::where('name', 'passport')->where('user_id', $user->id)->update([
                'name' => 'passport',
                'path_file' => $passport,
                'user_id' => $user->id,
            ]);
        }
        if (isset($request->licence))
        {
            $licence_delete = File::delete($licence, $disk = 'secret');
            $licence = File::uploadImage($request->licence, 'users', $width = null, $height = null, $disk = 'secret');
            $updateUserGallery = UsersGallery::where('name', 'licence')->where('user_id', $user->id)->update([
                'name' => 'licence',
                'path_file' => $licence,
                'user_id' => $user->id,
            ]);
        }


        $user->mobile = $request->mobile;
        $user->state = 'accepted';
        $user->update();

        $dateTime = Carbon::createFromFormat('Y-m-d H:i', $request->birth_date);
        $dateOnly = $dateTime->format('Y-m-d');
        $jalalian = Jalalian::fromFormat('Y-m-d', $dateOnly);
        $birth_date = $jalalian->toCarbon()->format('Y-m-d');

        $profile = Profile::where('user_id', $user->id)->first();
        $profile = Profile::find($profile->id);

        $profile->first_name = $request->firstname;
        $profile->user_id = $user->id;
        $profile->major_id = $request->major_id;
        $profile->last_name = $request->lastname;
        $profile->latin_first_name = $request->latin_firstname;
        $profile->latin_last_name = $request->latin_lastname;
        $profile->father_name = $request->father_name;
        $profile->latin_father_name = $request->latin_father_name;
        $profile->certificate_number = $request->certificate_number;
        $profile->gender = $request->gender;
        $profile->city_id = $request->city_id;
        $profile->province_id = $request->province_id;
        $profile->blood_type = $request->blood_type;
        $profile->position_id = $request->position_id;
        $profile->postal_code = $request->postal_code;
        $profile->postal_address = $request->postal_address;
        $profile->birth_date = $birth_date;
        $profile->education_id = $request->education_id;
        $profile->update();

        session::flash('success','با موفقیت انجام شد');
        return redirect()->route('admin.user.index');
    }
    public function destroy(User $user)
    {
        $user->delete();

        Session::flash('success','با موفقیت انجام شد');
        return redirect()->back();
    }
    public function bulkAction()
    {
        $items = [];
        $items = explode(',',Request()->items);

        if(isset($_GET['delete']))
        {
//            $this->authorize('education.delete');
            User::whereIn('id',$items)->delete();
        }
        if (isset($_GET['unPublish']))
        {
//            $this->authorize('product.edit');
            User::whereIn('id',$items)->update([
                'state' => 0
            ]);
        }
        if(isset($_GET['publish']))
        {
//            $this->authorize('product.edit');
            User::whereIn('id',$items)->update([
                'state' => 1
            ]);
        }

        session::flash('success','با موفقیت انجام شد');
        return redirect()->back();

    }
    public function createNote($id, Request $request)
    {
        $user = User::find($id);

        $user->state = 'rejected';
        $user->save();

        $user->notes()->create(
            [
                'note' => $request->title,
                'admin_id' => Auth::user()->id,
                'user_id' => $user->id,
                'state' => '0',
                'read' => '0',
            ]);
        Session::flash('success','با موفقیت انجام شد');
        return redirect()->route('admin.user.index');
    }
    public function messages($id)
    {
        $user_messages = Message::where('user_id', $id)->get();
        $user = User::find($id);

        return view('user::Dashboard.Frest.user.messages', compact('user_messages', 'user'));
    }
    public function createMessage($id, Request $request)
    {
        $createMessage = Message::create([
            'message' => $request->message,
            'admin_id' => Auth::user()->id,
            'user_id' => $id,
            'read' => 0,
        ]);

        session::flash('success','با موفقیت انجام شد');
        return redirect()->route('admin.messages', $id);
    }
    public function UpdateMessage($id, Request $request)
    {
        $user_message = Message::find($id);
        $user_message->message = $request->message;
        $user_message->read = 0;
        $user_message->update();

        session::flash('success','با موفقیت انجام شد');
        return redirect()->route('admin.messages', $user_message->user_id);
    }
    public function destroyMessage($id)
    {
        $destroyMessage = Message::find($id);
        $destroyMessage->delete();

        Session::flash('success','با موفقیت انجام شد');
        return redirect()->back();
    }
}
