<?php

namespace Modules\User\app\Http\Requests\Dashboard\Frest\Education;

use Illuminate\Foundation\Http\FormRequest;
use Illuminate\Validation\Rule;

class EducationStorRequest extends FormRequest
{
    /**
     * Get the validation rules that apply to the request.
     */
    public function rules(): array
    {
        return [
            'title' => [
                'required',
                Rule::unique('education', 'title'),
            ],
            'name' => [
                'required',
                Rule::unique('education', 'name'),
            ],
        ];
    }

    /**
     * Determine if the user is authorized to make this request.
     */
    public function authorize(): bool
    {
        return true;
    }
}
