<?php

namespace Modules\User\app\Http\Requests\Dashboard\Frest\Education;

use Illuminate\Foundation\Http\FormRequest;
use Illuminate\Validation\Rule;

class EducationUpdateRequest extends FormRequest
{
    /**
     * Get the validation rules that apply to the request.
     */
    public function rules(): array
    {
         $educationId = $this->route('education')->id;
         return [
            'title' => [
                'required',
                Rule::unique('education', 'title')->ignore($educationId),
            ],
            'name' => [
                'required',
                Rule::unique('education', 'name')->ignore($educationId),
            ],
        ];
    }

    /**
     * Determine if the user is authorized to make this request.
     */
    public function authorize(): bool
    {
        return true;
    }
}
