<?php

namespace Modules\User\app\Http\Requests\Dashboard\Frest\Major;

use Illuminate\Foundation\Http\FormRequest;
use Illuminate\Validation\Rule;

class MajorStorRequest extends FormRequest
{
    /**
     * Get the validation rules that apply to the request.
     */
    public function rules(): array
    {
        return [
            'title' => [
                'required',
                Rule::unique('major', 'title'),
            ],
            'name' => [
                'required',
                Rule::unique('major', 'name'),
            ],
        ];
    }

    /**
     * Determine if the user is authorized to make this request.
     */
    public function authorize(): bool
    {
        return true;
    }
}
