<?php

namespace Modules\User\app\Http\Requests\Dashboard\Frest\Major;

use Illuminate\Foundation\Http\FormRequest;
use Illuminate\Validation\Rule;

class MajorUpdateRequest extends FormRequest
{
    /**
     * Get the validation rules that apply to the request.
     */
    public function rules(): array
    {
        $majorId = $this->route('major')->id;
        return [
            'title' => [
                'required',
                Rule::unique('major', 'title')->ignore($majorId),
            ],
            'name' => [
                'required',
                Rule::unique('major', 'name')->ignore($majorId),
            ],
        ];
    }

    /**
     * Determine if the user is authorized to make this request.
     */
    public function authorize(): bool
    {
        return true;
    }
}
