<?php

namespace Modules\User\app\Http\Requests\Dashboard\Frest\User;

use Illuminate\Foundation\Http\FormRequest;
use Illuminate\Validation\Rule;

class UserStorRequest extends FormRequest
{
    /**
     * Get the validation rules that apply to the request.
     */
    public function rules(): array
    {
        return [
            'firstname' => [
                'required'
            ],
            'mobile' => [
                'required',
                Rule::unique('site_users', 'mobile'),
            ],
            'certificate_number' => [
                'required',
                Rule::unique('profile', 'certificate_number'),
            ],
            'national_card' => 'required|max:1024',
            'certificate_card' => 'required|max:1024',
            'personal_photo' => 'required|max:1024',
            'passport' => 'required|max:1024',
            'licence' => 'required|max:1024',
        ];
    }

    /**
     * Determine if the user is authorized to make this request.
     */
    public function authorize(): bool
    {
        return true;
    }
}
