<?php

namespace Modules\User\app\Http\Requests\Dashboard\Frest\User;

use Illuminate\Foundation\Http\FormRequest;
use Illuminate\Validation\Rule;
use Modules\User\app\Models\Profile;

class UserUpdateRequest extends FormRequest
{
    /**
     * Get the validation rules that apply to the request.
     */
    public function rules(): array
    {
        $userId = $this->route('user')->id;
       $profile = Profile::where('user_id', $userId)->first();
        return [
            'firstname' => [
                'required',
            ],
            'mobile' => [
                'required',
                Rule::unique('site_users', 'mobile')->ignore($userId),
            ],
            'certificate_number' => [
                'required',
                Rule::unique('profile', 'certificate_number')->ignore($profile->id),
            ],
        ];
    }

    /**
     * Determine if the user is authorized to make this request.
     */
    public function authorize(): bool
    {
        return true;
    }
}
