<?php

namespace Modules\User\app\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Modules\User\Database\factories\EducationFactory;
use Illuminate\Database\Eloquent\SoftDeletes;

class Education extends Model
{
    use HasFactory;

    protected $table = 'education';

    protected $fillable = [
        'title',
        'name',
        'state',
    ];

    public function profiles()
    {
        return $this->hasMany(Profile::class, 'education_id');
    }
}
