<?php

namespace Modules\User\app\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Modules\User\Database\factories\MajorFactory;
use Illuminate\Database\Eloquent\SoftDeletes;

class Major extends Model
{
    use HasFactory;

    protected $table = 'major';

    protected $fillable = [
        'title',
        'name',
        'state',
    ];

    public function profiles()
    {
        return $this->hasMany(Profile::class, 'major_id');
    }
}
