<?php

namespace Modules\User\app\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Modules\User\Database\factories\PositionFactory;

class Position extends Model
{
    use HasFactory;

    protected $table = 'position';

    protected $fillable = [
        'title',
        'name',
    ];

    public function profiles()
    {
        return $this->hasMany(Profile::class, 'position_id');
    }
}
