<?php

namespace Modules\User\app\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Modules\User\Database\factories\ProfileFactory;
use Illuminate\Database\Eloquent\SoftDeletes;

class Profile extends Model
{
    use HasFactory;

    protected $table = 'profile';
    protected $fillable = [
        'first_name',
        'last_name',
        'father_name',
        'latin_first_name',
        'latin_last_name',
        'latin_father_name',
        'certificate_number',
        'city_id',
        'city_name',
        'birth_date',
        'province_id',
        'province_name',
        'gender',
        'blood_type',
        'postal_code',
        'user_id',
        'education_id',
        'major_id',
        'postal_address',
    ];

    public function user()
    {
        return $this->belongsTo(User::class, 'user_id');
    }

    public function education()
    {
        return $this->belongsTo(Education::class, 'education_id');
    }

    public function position()
    {
        return $this->belongsTo(Position::class, 'position_id');
    }

    public function major()
    {
        return $this->belongsTo(Major::class, 'major_id');
    }
}
