<?php

namespace Modules\User\app\Models;


use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Notifications\Notifiable;
use Modules\Note\app\Models\Note;
use Modules\User\Database\factories\UserFactory;
use Illuminate\Foundation\Auth\User as Authenticatable;
use Laravel\Sanctum\HasApiTokens;

class User extends Authenticatable
{
    use HasApiTokens, HasFactory, Notifiable;

    protected $table = 'site_users';

    protected $fillable = [
        'mobile',
        'state',
        'password',
        'send_message',
    ];


    protected $hidden = [
        'password',
        'remember_token',
    ];

    protected $casts = [
        'password' => 'hashed',
    ];

    public function profile()
    {
        return $this->hasOne(Profile::class, 'user_id');
    }

    public function galleries()
    {
        return $this->hasMany(UsersGallery::class, 'user_id');
    }

    public function notes()
    {
        return $this->morphMany(Note::class, 'note','object_type','object_id');
    }
}
