@extends('core::Dashboard.Frest.Layouts.master')

@section('title')داشبورد@endsection

@section('style')
    <link rel="stylesheet" href="{{asset('modules/core/vendor/libs/tagify/tagify.css')}}" />
@endsection

@section('script')


    <script src="{{asset('modules/core/editors/ckeditor/ckeditor.js')}}"></script>

    <script src="{{asset('modules/core/vendor/libs/tagify/tagify.js')}}"></script>

    <script>
        var options = {
            filebrowserImageBrowseUrl: '/file-manager/ckeditor',
        };
        CKEDITOR.replace('body' ,options);
        $('#submit').on('keyup keypress', function(e) {
            var keyCode = e.keyCode || e.which;
            if (keyCode === 13) {
                e.preventDefault();
                return false;
            }
        });
    </script>

    <script>

        const tag1 = document.querySelector("#tag");
        const tag = new Tagify(tag1, {
            {{--whitelist: [{!!  \Modules\Core\app\Http\Controllers\Helpers\Str::implodeArray($tags->pluck('name')->toArray()) !!}],--}}
            dropdown: {
                classname: "tags-look", // <- custom classname for this dropdown, so it could be targeted
                enabled: 0,             // <- show suggestions on focus
                closeOnSelect: false    // <- do not hide the suggestions dropdown once an item has been selected
            }
        });
    </script>

@endsection

@section('content')

    @include('core::components.file_set_to_editor')

    <div class="row">
        <div class="col 12">
            <h6 class="mt-4 secondary-font">ثبت</h6>
            <div class="row">
                <div class="card mb-3">
                    <div class="card-header border-bottom primary-font">
                        <ul class="nav nav-tabs card-header-tabs" role="tablist">
                            <li class="nav-item">
                                <button class="nav-link active" data-bs-toggle="tab" data-bs-target="#tab1" role="tab" aria-selected="true">
                                    کاربران
                                </button>
                            </li>
                        </ul>
                    </div>

                    <div class="tab-content">
                        <form id="formData" enctype="multipart/form-data" action="{{route('admin.user.store')}}" method="post">
                            {{ csrf_field() }}
                            @method('post')
                            <div class="tab-pane fade active show" id="tab1" role="tabpanel">
                                <div class="row g-3">
                                    <div class="col-md-13">
                                        <div class="row">
                                            <div class="row">
                                                <div class="col-md-3">
                                                    <span>*</span>
                                                    <label class="form-label" for="firstname">نام</label>
                                                    <input type="text" id="firstname" name="firstname" class="form-control"
                                                           placeholder="نام" required>
                                                    @if ($errors->has('firstname'))
                                                        <div data-field="firstname" class="text-danger">{{ $errors->first('firstname') }}
                                                        </div>
                                                    @endif
                                                </div>
                                                <div class="col-md-3">
                                                    <span>*</span>
                                                    <label class="form-label" for="lastname">نام خانوادگی</label>
                                                    <input type="text" id="lastname" name="lastname" class="form-control"
                                                           placeholder="نام" required>
                                                    @if ($errors->has('lastname'))
                                                        <div data-field="lastname" class="text-danger">{{ $errors->first('lastname') }}
                                                        </div>
                                                    @endif
                                                </div>
                                                <div class="col-md-3">
                                                    <span>*</span>
                                                    <label class="form-label" for="latin_firstname">نام لاتین</label>
                                                    <input type="text" id="latin_firstname" name="latin_firstname" class="form-control"
                                                           placeholder="نام" required>
                                                    @if ($errors->has('latin_firstname'))
                                                        <div data-field="latin_firstname" class="text-danger">{{ $errors->first('latin_firstname') }}
                                                        </div>
                                                    @endif
                                                </div>
                                                <div class="col-md-3">
                                                    <span>*</span>
                                                    <label class="form-label" for="latin_lastname">نام خانوادگی لاتین</label>
                                                    <input type="text" id="latin_lastname" name="latin_lastname" class="form-control"
                                                           placeholder="نام" required>
                                                    @if ($errors->has('latin_lastname'))
                                                        <div data-field="latin_lastname" class="text-danger">{{ $errors->first('latin_lastname') }}
                                                        </div>
                                                    @endif
                                                </div>
                                            </div>

                                            <div class="row">
                                                <div class="col-md-3">
                                                    <span>*</span>
                                                    <label class="form-label" for="father_name">نام پدر</label>
                                                    <input type="text" id="father_name" name="father_name" class="form-control" placeholder="نام" required>
                                                    @if ($errors->has('father_name'))
                                                        <div data-field="father_name" class="text-danger">{{ $errors->first('father_name') }}
                                                        </div>
                                                    @endif
                                                </div>
                                                <div class="col-md-3">
                                                    <span>*</span>
                                                    <label class="form-label" for="latin_father_name">نام پدر لاتین</label>
                                                    <input type="text" id="latin_father_name" name="latin_father_name" class="form-control"
                                                           placeholder="نام" required>
                                                    @if ($errors->has('latin_father_name'))
                                                        <div data-field="latin_father_name" class="text-danger">{{ $errors->first('latin_father_name') }}
                                                        </div>
                                                    @endif
                                                </div>
                                                <div class="col-md-3">
                                                    <span>*</span>
                                                    <label class="form-label" for="certificate_number">شماره شناسنامه</label>
                                                    <input type="text" id="certificate_number" name="certificate_number" class="form-control"
                                                           placeholder="نام" required>
                                                    @if ($errors->has('certificate_number'))
                                                        <div data-field="certificate_number" class="text-danger">{{ $errors->first('certificate_number') }}
                                                        </div>
                                                    @endif
                                                </div>
                                                <div class="col-md-3">
                                                    <span>*</span>
                                                    <label class="form-label" for="gender">جنسیت</label>
                                                    <div class="position-relative">
                                                        <select id="gender" name="gender" class="form-select" required>
                                                            <option value="مرد">مرد</option>
                                                            <option value="زن">زن</option>
                                                        </select>
                                                    </div>
                                                </div>
                                            </div>

                                            <div class="row">
                                                <div class="col-md-3">
                                                    <span>*</span>
                                                    <label class="form-label" for="title">موبایل</label>
                                                    <input type="text" id="mobile"  name="mobile" class="form-control" placeholder="موبایل" required>
                                                    @if($errors->has('mobile'))
                                                        <div data-field="mobile" class="text-danger">{{ $errors->first('mobile') }}</div>
                                                    @endif
                                                </div>
{{--                                                <div class="col-md-3">--}}
{{--                                                    <span>*</span>--}}
{{--                                                    <label class="form-label" for="state">وضعیت</label>--}}
{{--                                                    <div class="position-relative">--}}
{{--                                                        <select id="state" name="state" class="form-select">--}}
{{--                                                            <option value="1">فعال</option>--}}
{{--                                                            <option value="0">غیر فعال</option>--}}
{{--                                                        </select>--}}
{{--                                                    </div>--}}
{{--                                                </div>--}}
                                                <div class="col-md-3">
                                                    <span>*</span>
                                                    <label class="form-label" for="major">تحصیلات</label>
                                                    <div class="position-relative">
                                                        <select id="major" name="major_id" class="form-select" required>
                                                            @foreach($majors as $major)
                                                                <option value="{{ $major->id }}">{{ $major->title }}</option>
                                                            @endforeach
                                                        </select>
                                                    </div>
                                                </div>
                                                <div class="col-md-3">
                                                    <span>*</span>
                                                    <label class="form-label" for="major">رشته تحصیلی</label>
                                                    <div class="position-relative">
                                                        <select id="major" name="education_id" class="form-select" required>
                                                            @foreach($educations as $education)
                                                                <option value="{{ $education->id }}" selected>{{ $education->title }}</option>
                                                            @endforeach
                                                        </select>
                                                    </div>
                                                </div>
                                            </div>

                                            <div class="row">
                                                <div class="col-md-3">
                                                    <span>*</span>
                                                    <label class="form-label" for="city_id">شهر</label>
                                                    <div class="position-relative">
                                                        <select id="city_id" name="city_id" class="form-select" required>
                                                            @foreach($cities as $citY)
                                                                <option value="{{ $citY->id }}">{{ $citY->title }}</option>
                                                            @endforeach
                                                        </select>
                                                    </div>
                                                </div>
                                                <div class="col-md-3">
                                                    <span>*</span>
                                                    <label class="form-label" for="major">استان محل تولد</label>
                                                    <div class="position-relative">
                                                        <select id="province_id" name="province_id" class="form-select" required>
                                                            @foreach($provinces as $province)
                                                                <option value="{{ $province->id }}">{{ $province->title }}</option>
                                                            @endforeach
                                                        </select>
                                                    </div>
                                                </div>
                                                <div class="col-md-3">
                                                    <span>*</span>
                                                    <label class="form-label" for="city_id">گروه خونی</label>
                                                    <div class="position-relative">
                                                        <select id="blood_type" name="blood_type" class="form-select" required>
                                                            <option value="A+">A+</option>
                                                            <option value="A-">A-</option>
                                                            <option value="B+">B+</option>
                                                            <option value="B-">B-</option>
                                                            <option value="AB+">AB+</option>
                                                            <option value="AB-">AB-</option>
                                                            <option value="O+">O+</option>
                                                            <option value="O-">O-</option>
                                                        </select>
                                                    </div>
                                                </div>
                                                <div class="col-md-3">
                                                    <span>*</span>
                                                    <label class="form-label" for="major">سمت</label>
                                                    <div class="position-relative">
                                                        <select id="position_id" name="position_id" class="form-select" required>
                                                            @foreach($positions as $position)
                                                                <option value="{{ $position->id }}">{{ $position->title }}</option>
                                                            @endforeach
                                                        </select>
                                                    </div>
                                                </div>
                                            </div>

                                            <div class="row">
                                                <div class="col-md-3">
                                                    <span>*</span>
                                                    <label class="form-label" for="postal_code">کد پستی</label>
                                                    <input type="text" id="postal_code"  name="postal_code" class="form-control" placeholder="کد پستی" required>
                                                    @if($errors->has('postal_code'))
                                                        <div data-field="postal_code" class="text-danger">{{ $errors->first('postal_code') }}</div>
                                                    @endif
                                                </div>
                                                <div class="col-md-3">
                                                    <span>*</span>
                                                    <label class="form-label" for="title">آدرس پستی</label>
                                                    <input type="text" id="postal_address"  name="postal_address" class="form-control" placeholder="آدرس پستی" required>
                                                    @if($errors->has('postal_address'))
                                                        <div data-field="postal_address" class="text-danger">{{ $errors->first('postal_address') }}</div>
                                                    @endif
                                                </div>
                                                <div class="col-md-3">
                                                    <div class="col-md-12">
                                                        <span>*</span>
                                                        <label for="flatpickr-datetime" class="form-label">تاریخ تولد</label>
                                                        <input type="text" class="form-control" placeholder="YYYY-MM-DD" name="birth_date" id="publish_up"  value="{{old('birth_date')}}" required/>
                                                    </div>
                                                    @if ($errors->has('birth_date'))
                                                        <div data-field="birth_date" class="text-danger">{{ $errors->first('birth_date') }}
                                                        </div>
                                                    @endif
                                                </div>
                                            </div>

                                            <div class="row mt-4">
                                                <div class="col-md-6">
                                                    <span>*</span>
                                                    <label class="form-label" for="title">تصویر کارت ملی</label>
                                                    <div class="input-group">
                                                        <input type="file" id="image-2" class="form-control" name="national_card"
                                                               aria-label="Image" aria-describedby="button-image-2" required>
                                                        <div class="input-group-append">
                                                            {{--                                                        <button class="btn btn-outline-secondary" type="button">--}}
                                                            {{--                                                            <a href="{{  route('admin.user.show', $user->galleries[0]->id) }}">دیدن تصویر</a>--}}
                                                            {{--                                                        </button>--}}
                                                        </div>
                                                        @if ($errors->has('national_card'))
                                                            <div data-field="national_card" class="text-danger">{{ $errors->first('national_card') }}
                                                            </div>
                                                        @endif
                                                    </div>
                                                </div>
                                                <div class="col-md-6">
                                                    <span>*</span>
                                                    <label class="form-label" for="title">تصویر شناسنامه</label>
                                                    <div class="input-group">
                                                        <input type="file" id="image-2" class="form-control" name="certificate_card"
                                                               aria-label="Image" aria-describedby="button-image-2" required>
                                                        <div class="input-group-append">
                                                            {{--                                                        <button class="btn btn-outline-secondary" type="button">--}}
                                                            {{--                                                            <a href="{{  route('admin.user.show', $user->galleries[1]->id) }}">دیدن تصویر</a>--}}
                                                            {{--                                                        </button>--}}
                                                        </div>
                                                        @if ($errors->has('certificate_card'))
                                                            <div data-field="certificate_card" class="text-danger">{{ $errors->first('certificate_card') }}
                                                            </div>
                                                        @endif
                                                    </div>
                                                </div>
                                                <div class="col-md-6">
                                                    <span>*</span>
                                                    <label class="form-label" for="title">عکس پرسنلی</label>
                                                    <div class="input-group">
                                                        <input type="file" id="image-2" class="form-control" name="personal_photo"
                                                               aria-label="Image" aria-describedby="button-image-2" required>
                                                        <div class="input-group-append">
                                                            {{--                                                        <button class="btn btn-outline-secondary" type="button">--}}
                                                            {{--                                                            <a href="{{  route('admin.user.show', $user->galleries[2]->id) }}">دیدن تصویر</a>--}}
                                                            {{--                                                        </button>--}}
                                                        </div>
                                                        @if ($errors->has('personal_photo'))
                                                            <div data-field="personal_photo" class="text-danger">{{ $errors->first('personal_photo') }}
                                                            </div>
                                                        @endif
                                                    </div>
                                                </div>
                                                <div class="col-md-6">
                                                    <span>*</span>
                                                    <label class="form-label" for="title">پاسپورت</label>
                                                    <div class="input-group">
                                                        <input type="file" id="image-2" class="form-control" name="passport"
                                                               aria-label="Image" aria-describedby="button-image-2" required>
                                                        <div class="input-group-append">
                                                            {{--                                                        <button class="btn btn-outline-secondary" type="button">--}}
                                                            {{--                                                            <a href="{{  route('admin.user.show', $user->galleries[3]->id) }}">دیدن تصویر</a>--}}
                                                            {{--                                                        </button>--}}
                                                        </div>
                                                        @if ($errors->has('passport'))
                                                            <div data-field="passport" class="text-danger">{{ $errors->first('passport') }}
                                                            </div>
                                                        @endif
                                                    </div>
                                                </div>
                                                <div class="col-md-6">
                                                    <span>*</span>
                                                    <label class="form-label" for="title">گواهینامه</label>
                                                    <div class="input-group">
                                                        <input type="file" id="image-2" class="form-control" name="licence"
                                                               aria-label="Image" aria-describedby="button-image-2" required>
                                                        <div class="input-group-append">
                                                            {{--                                                        <button class="btn btn-outline-secondary" type="button">--}}
                                                            {{--                                                            <a href="{{  route('admin.user.show', $user->galleries[4]->id) }}">دیدن تصویر</a>--}}
                                                            {{--                                                        </button>--}}
                                                        </div>
                                                        @if ($errors->has('licence'))
                                                            <div data-field="licence" class="text-danger">{{ $errors->first('licence') }}
                                                            </div>
                                                        @endif
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>


                            {{--                        @foreach($field_groups->where('type','products') as $group)--}}

                            {{--                            <div class="tab-pane fade " id="{{$group->name}}" role="tabpanel">--}}


                            {{--                                <div class="row g-3">--}}

                            {{--                                    <div class="col-md-12">--}}

                            {{--                                        <div class="row">--}}

                            {{--                                            @foreach($group->fields as $field)--}}



                            {{--                                                @if($field->type == 'string')--}}
                            {{--                                                    <div class="col-md-6">--}}
                            {{--                                                        <label for="{{$field->name}}" class="form-label">{{$field->title}}</label>--}}
                            {{--                                                        <input type="text" class="form-control" name="fields[{{$field->name}}]" id="{{$field->name}}" value="{{isset($product) && $product->fields->where('field_id',$field->id)->first() != null ? $product        ->fields->where('field_id',$field->id)->first()->value->value : ''}}" />--}}
                            {{--                                                    </div>--}}
                            {{--                                                @endif--}}


                            {{--                                            @endforeach--}}


                            {{--                                        </div>--}}

                            {{--                                    </div>--}}




                            {{--                                </div>--}}


                            {{--                            </div>--}}


                            {{--                        @endforeach--}}
                            <div class="pt-4">
                                <button type="submit" name="save" class="btn btn-primary me-sm-3 me-1">ثبت</button>
                                <a href="{{route('admin.user.index')}}" type="reset" class="btn btn-label-secondary">انصراف</a>
                            </div>

                        </form>
                    </div>
                </div>
            </div>
        </div>
    </div>


    <script src="{{ asset('modules/core/js/slug-edit.js') }}"></script>

@endsection
