@extends('core::Dashboard.Frest.Layouts.master')

@section('title')
    داشبورد
@endsection

@section('style')
@endsection

@section('script')
    <script src="{{ asset('modules/core/js/dashboards-analytics.js') }}"></script>
@endsection

@section('content')
    <div class="card" style="margin-bottom:15px; ">
        <p class="demo-inline-spacing">
            <button type="button" class="btn btn-icon me-2 btn-primary" type="button" data-bs-toggle="collapse"
                    data-bs-target=".multi-collapse" aria-expanded="false"
                    aria-controls="multiCollapseExample1 multiCollapseExample2">
                <i class="bx bx-search bx-sm"></i>
            </button>


        </p>

        <section>
            <div class="row">

                <div class="row">
                    <div class="col-12 col-md-12">
                        <div class="collapse multi-collapse" id="multiCollapseExample2">
                            <div class="col-md-12" style="padding: 0.8%;">
                                <form id="filter" action="{{route('admin.user.list','news')}}"
                                      method="get">
                                    <div class="row">
                                        <div class="col-md-2">
                                            <input type="text" id="q" name="q" class="form-control" placeholder="جستجو"
                                                   value="{{ old('q') }}">
                                        </div>
                                        <div class="col-md-2">
                                            <button onclick="submitForm('filter')" name="filter" type="button"
                                                    class="btn btn-primary me-1">جستجو</button>
                                        </div>
                                    </div>
                                </form>
                            </div>
                        </div>
                    </div>
                </div>



            </div>
        </section>
    </div>


    <div class="card">
{{--        <x-modal id="add_user" size="sm" header="ثبت کاربر">--}}
{{--            <form id="formData" enctype="multipart/form-data" action="{{ route('admin.user.store') }}" method="post">--}}
{{--                {{ csrf_field() }}--}}

{{--                <div class="tab-pane fade active show" id="tab1" role="tabpanel">--}}
{{--                    <div class="row g-3">--}}
{{--                        <div class="col-md-12">--}}
{{--                            <div class="row">--}}
{{--                                <div class="col-md-6">--}}
{{--                                    <span>*</span>--}}
{{--                                    <label class="form-label" for="firstname">نام</label>--}}
{{--                                    <input type="text" id="firstname" name="firstname" class="form-control"--}}
{{--                                           placeholder="نام" value="" required>--}}
{{--                                    @if ($errors->has('firstname'))--}}
{{--                                        <div data-field="firstname" class="text-danger">{{ $errors->first('firstname') }}--}}
{{--                                        </div>--}}
{{--                                    @endif--}}
{{--                                </div>--}}
{{--                                <div class="col-md-6">--}}
{{--                                    <span>*</span>--}}
{{--                                    <label class="form-label" for="title">موبایل</label>--}}
{{--                                    <input type="text" id="mobile"  name="mobile" class="form-control" required placeholder="موبایل" value="{{old('mobile')}}">--}}
{{--                                    @if($errors->has('mobile'))--}}
{{--                                        <div data-field="mobile" class="text-danger">{{ $errors->first('mobile') }}</div>--}}
{{--                                    @endif--}}
{{--                                </div>--}}
{{--                                <div class="col-md-6">--}}
{{--                                    <span>*</span>--}}
{{--                                    <label class="form-label" for="state">وضعیت</label>--}}
{{--                                    <div class="position-relative">--}}
{{--                                        <select id="state" name="state" class="form-select" required>--}}
{{--                                            <option value="1" {{ '1' == old('state') ? 'selected' : '' }}>فعال--}}
{{--                                            </option>--}}
{{--                                            <option value="0" {{ '0' == old('state') ? 'selected' : '' }}>غیر--}}
{{--                                                فعال</option>--}}
{{--                                        </select>--}}
{{--                                    </div>--}}
{{--                                </div>--}}
{{--                                <div class="col-md-6">--}}
{{--                                    <span>*</span>--}}
{{--                                    <label class="form-label" for="major">تحصیلات</label>--}}
{{--                                    <div class="position-relative">--}}
{{--                                        <select id="major" required name="major_id" class="form-select">--}}
{{--                                            @foreach($majors as $major)--}}
{{--                                                <option value="{{ $major->id }}">{{ $major->title }}</option>--}}
{{--                                            @endforeach--}}
{{--                                        </select>--}}
{{--                                    </div>--}}
{{--                                </div>--}}
{{--                                <div class="col-md-6">--}}
{{--                                    <span>*</span>--}}
{{--                                    <label class="form-label" for="major">رشته تحصیلی</label>--}}
{{--                                    <div class="position-relative">--}}
{{--                                        <select id="major" name="education_id" class="form-select" required>--}}
{{--                                            @foreach($educations as $education)--}}
{{--                                                <option value="{{ $education->id }}">{{ $education->title }}</option>--}}
{{--                                            @endforeach--}}
{{--                                        </select>--}}
{{--                                    </div>--}}
{{--                                </div>--}}
{{--                                <div class="col-md-12">--}}
{{--                                    <span>*</span>--}}
{{--                                    <label class="form-label" for="title">تصویر کارت ملی</label>--}}
{{--                                    <input type="file" id="image-2" class="form-control" name="national_card"--}}
{{--                                           aria-label="Image" aria-describedby="button-image-2" required>--}}
{{--                                    @if ($errors->has('national_card'))--}}
{{--                                        <div data-field="national_card" class="text-danger">{{ $errors->first('national_card') }}--}}
{{--                                        </div>--}}
{{--                                    @endif--}}
{{--                                </div>--}}
{{--                                <div class="col-md-12">--}}
{{--                                    <span>*</span>--}}
{{--                                    <label class="form-label" for="title">تصویر شناسنامه</label>--}}
{{--                                    <input type="file" id="image-2" class="form-control" name="certificate_card"--}}
{{--                                           aria-label="Image" aria-describedby="button-image-2" required>--}}
{{--                                    @if ($errors->has('certificate_card'))--}}
{{--                                        <div data-field="certificate_card" class="text-danger">{{ $errors->first('certificate_card') }}--}}
{{--                                        </div>--}}
{{--                                    @endif--}}
{{--                                </div>--}}
{{--                                <div class="col-md-12">--}}
{{--                                    <span>*</span>--}}
{{--                                    <label class="form-label" for="title">عکس پرسنلی</label>--}}
{{--                                    <input type="file" id="image-2" class="form-control" name="personal_photo"--}}
{{--                                           aria-label="Image" aria-describedby="button-image-2" required>--}}
{{--                                    @if ($errors->has('personal_photo'))--}}
{{--                                        <div data-field="personal_photo" class="text-danger">{{ $errors->first('personal_photo') }}--}}
{{--                                        </div>--}}
{{--                                    @endif--}}
{{--                                </div>--}}
{{--                                <div class="col-md-12">--}}
{{--                                    <span>*</span>--}}
{{--                                    <label class="form-label" for="title">پاسپورت</label>--}}
{{--                                    <input type="file" id="image-2" class="form-control" name="passport"--}}
{{--                                           aria-label="Image" aria-describedby="button-image-2" required>--}}
{{--                                    @if ($errors->has('passport'))--}}
{{--                                        <div data-field="passport" class="text-danger">{{ $errors->first('passport') }}--}}
{{--                                        </div>--}}
{{--                                    @endif--}}
{{--                                </div>--}}
{{--                                <div class="col-md-12">--}}
{{--                                    <span>*</span>--}}
{{--                                    <label class="form-label" for="title">گواهینامه</label>--}}
{{--                                    <input type="file" id="image-2" class="form-control" name="licence"--}}
{{--                                           aria-label="Image" aria-describedby="button-image-2" required>--}}
{{--                                    @if ($errors->has('licence'))--}}
{{--                                        <div data-field="licence" class="text-danger">{{ $errors->first('licence') }}--}}
{{--                                        </div>--}}
{{--                                    @endif--}}
{{--                                </div>--}}
{{--                            </div>--}}
{{--                        </div>--}}
{{--                    </div>--}}
{{--                </div>--}}
{{--                <div class="pt-4">--}}
{{--                    <button type="submit" name="save" class="btn btn-primary me-sm-3 me-1">ثبت</button>--}}
{{--                    <a href="{{ route('admin.user.index') }}" type="reset"--}}
{{--                       class="btn btn-label-secondary">انصراف</a>--}}
{{--                </div>--}}
{{--            </form>--}}
{{--        </x-modal>--}}
        <form action="{{ route('admin.bulk.users') }}" method="get">
            <p class="demo-inline-spacing">
                <a class="btn btn-primary me-1" href="{{ route('admin.user.create') }}" role="button"
                   aria-expanded="false">جدید</a>
{{--                <button type="button" class="btn btn-primary me-1" data-bs-toggle="modal" data-bs-target="#add_user">--}}
{{--                    جدید--}}
{{--                </button>--}}
                <button name="publish" type="submit" class="btn btn-success me-1">انتشار</button>
                <button name="unPublish" type="submit" class="btn btn-gray me-1">غیر انتشار</button>
                <button name="delete" type="submit" class="btn btn-danger me-1">حذف</button>
            </p>
            <input type="text" id="items" name="items" value="" style="display: none;">
        </form>
        <h5 class="card-header">{{\Modules\Core\app\Http\Controllers\Helpers\Str::getTitleBoard("کاربران")}}</h5>
        <div class="table-responsive text-nowrap">
            <table class="table table-sm">
                <thead>
                <tr>
                    <th>
                        <div class="bulk-ids checkbox-primary m-r-15">
                            <input id="bulk-ids" onClick="toggle(this)" type="checkbox">
                            <label for="bulk-ids">#</label>
                        </div>
                    </th>
                    <th>نام</th>
                    <th>موبایل</th>
                    <th>رشته آموزشی</th>
                    <th>تحصیلات</th>
                    <th>ایجاد</th>
                    <th>وضعیت</th>
                    <th>عملیات</th>
                </tr>
                </thead>
                <tbody>

                @foreach ($users as $user)
                    <tr>
                        <th>
                            <div class="bulk-ids checkbox-primary m-r-15">
                                <input id="bulk-ids" onClick="syncItems(this)"
                                       name="ids[]"value="{{ $user->id }}" type="checkbox">
                                <label for="bulk-ids"></label>
                            </div>
                        </th>
                        <td>
                            @if($user->state == 0)
                                @if($user->profile != null)
                                    <a style="color: red" href="{{route('admin.user.index')}}">
                                        <b class="active">{{ $user->id }} -
                                            {{ $user->profile->first_name }}</b>
                                    </a>
                                @else
                                    <a style="color: red" href="{{route('admin.user.index')}}">
                                        <b class="active">{{ $user->id }} -
                                            {{ $user->id }}</b>
                                    </a>
                                @endif

                            @else
                                @if($user->profile != null)
                                    <a style="color: blue" href="{{route('admin.user.index')}}">
                                        <b class="active">{{ $user->id }} -
                                            {{ $user->profile->first_name }}</b>
                                    </a>
                                @else
                                    <a style="color: blue" href="{{route('admin.user.index')}}">
                                        <b class="active">{{ $user->id }} -
                                            {{ $user->id }}</b>
                                    </a>
                                @endif
                            @endif
                        </td>
                        <td>
                            {{$user->mobile}}
                        </td>

                        <td>
                            @if($user->profile != null)
                                {{$user->profile->education->title}}
                            @else
                                -
                            @endif

                        </td>
                        <td>
                            @if($user->profile != null)
                                {{$user->profile->major->title}}
                            @else
                                -
                            @endif
                        </td>

                        <td>
                            @if ($user->created_at != null)
                                {{ Verta($user->created_at)->format('Y-m-d H:i:s') }}
                            @endif
                        </td>

                        <td>
                            @if ($user->state == 'accepted')
                                <span class="badge bg-success">تایید شده</span>
                            @elseif($user->state == 'rejected')
                                <span class="badge bg-danger">رد شده</span>
                            @elseif($user->state == 'pending')
                                <span class="badge bg-warning">نیاز به بررسی</span>
                            @endif
                        </td>

                        <td>
                            <div class="dropdown">
                                <button type="button" class="btn p-0 dropdown-toggle hide-arrow"
                                        data-bs-toggle="dropdown"><i class="bx bx-dots-vertical-rounded"></i></button>
                                <div class="dropdown-menu">
                                    <a class="dropdown-item" href="{{ route('admin.messages', $user->id) }}"><i
                                            class="bx bx-edit-alt me-1"></i>پیام ها</a>

                                    <a class="dropdown-item" href="{{ route('admin.user.edit', $user->id) }}"><i
                                            class="bx bx-edit-alt me-1"></i>بررسی و ویرایش</a>

                                    <button class="dropdown-item"
                                            onclick="event.preventDefault();confirmDelete('delete-{{ $user->id }}')"><i
                                            class="bx bx-trash me-1"></i>حذف</button>
                                    <form id="delete-{{ $user->id }}"
                                          action="{{ route('admin.user.destroy', $user->id) }}" method="POST"
                                          style="display: none;">
                                        {{ csrf_field() }}
                                        {{ method_field('DELETE') }}
                                    </form>
                                </div>
                            </div>
                        </td>
                    </tr>

                    {{--                    @include('user::Dashboard.Frest.education._partial', [--}}
                    {{--                        'education' => $education,--}}
                    {{--                        'row' => 0,--}}
                    {{--                    ])--}}
                @endforeach

                </tbody>
            </table>

            <div style="margin-top: 10%;">
                {{--                {{ $educations->render() }}--}}
            </div>
        </div>
    </div>
@endsection
