@extends('core::Dashboard.Frest.Layouts.master')

@section('title')
    داشبورد
@endsection

@section('style')
@endsection

@section('script')
    <script src="{{ asset('modules/core/js/dashboards-analytics.js') }}"></script>
@endsection

@section('content')
    <div class="card" style="margin-bottom:15px; ">
        <p class="demo-inline-spacing">
            <button type="button" class="btn btn-icon me-2 btn-primary" type="button" data-bs-toggle="collapse"
                    data-bs-target=".multi-collapse" aria-expanded="false"
                    aria-controls="multiCollapseExample1 multiCollapseExample2">
                <i class="bx bx-search bx-sm"></i>
            </button>


        </p>

        <section>
            <div class="row">

                <div class="row">
                    <div class="col-12 col-md-12">
                        <div class="collapse multi-collapse" id="multiCollapseExample2">
                            <div class="col-md-12" style="padding: 0.8%;">
                                <form id="filter" action="{{route('admin.user.list','news')}}"
                                      method="get">
                                    <div class="row">
                                        <div class="col-md-2">
                                            <input type="text" id="q" name="q" class="form-control" placeholder="جستجو"
                                                   value="{{ old('q') }}">
                                        </div>
                                        <div class="col-md-2">
                                            <button onclick="submitForm('filter')" name="filter" type="button"
                                                    class="btn btn-primary me-1">جستجو</button>
                                        </div>
                                    </div>
                                </form>
                            </div>
                        </div>
                    </div>
                </div>



            </div>
        </section>
    </div>


    <div class="card">
        <x-modal id="add_user" size="sm" header="ثبت پیام جدید">
            <form id="formData" enctype="multipart/form-data" action="{{ route('admin.user.create.message', $user->id) }}" method="post">
                {{ csrf_field() }}

                <div class="tab-pane fade active show" id="tab1" role="tabpanel">
                    <div class="row g-3">
                        <div class="col-md-12">
                            <div class="row">
                                <div class="col-md-12">
                                    <span>*</span>
                                    <label class="form-label" for="firstname">متن پیام</label>
                                    <textarea name="message" class="form-control" placeholder="متن پیام" required></textarea>
                                    @if ($errors->has('message'))
                                        <div data-field="message" class="text-danger">{{ $errors->first('message') }}
                                        </div>
                                    @endif
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="pt-4">
                    <button type="submit" name="save" class="btn btn-primary me-sm-3 me-1">ثبت</button>
                    <a href="{{ route('admin.messages', $user->id) }}" type="reset"
                       class="btn btn-label-secondary">انصراف</a>
                </div>
            </form>
        </x-modal>
        <form action="{{ route('admin.bulk.users') }}" method="get">
            <p class="demo-inline-spacing">
                {{--                <a class="btn btn-primary me-1" href="{{ route('admin.user.create') }}" role="button"--}}
                {{--                   aria-expanded="false">جدید</a>--}}

                <button type="button" class="btn btn-primary me-1" data-bs-toggle="modal" data-bs-target="#add_user">
                    پیام جدید
                </button>
{{--                <button name="delete" type="submit" class="btn btn-danger me-1">حذف</button>--}}
            </p>
            <input type="text" id="items" name="items" value="" style="display: none;">
        </form>
        <h5 class="card-header">{{\Modules\Core\app\Http\Controllers\Helpers\Str::getTitleBoard("پیام ها")}}</h5>
        <div class="table-responsive text-nowrap">
            <table class="table table-sm">
                <thead>
                <tr>
                    <th>
                        <div class="bulk-ids checkbox-primary m-r-15">
                            <input id="bulk-ids" onClick="toggle(this)" type="checkbox">
                            <label for="bulk-ids">#</label>
                        </div>
                    </th>
                    <th>پیام</th>
                    <th>ایجاد</th>
                    <th>وضعیت</th>
                    <th>عملیات</th>
                </tr>
                </thead>
                <tbody>

                @foreach ($user_messages as $user_message)
                    <tr>
                        <th>
                            <div class="bulk-ids checkbox-primary m-r-15">
                                <input id="bulk-ids" onClick="syncItems(this)"
                                       name="ids[]"value="{{ $user->id }}" type="checkbox">
                                <label for="bulk-ids"></label>
                            </div>
                        </th>

                        <td>
                            {{ $user_message->message }}
                        </td>

                        <td>
                            @if ($user_message->created_at != null)
                                {{ Verta($user->created_at)->format('Y-m-d H:i:s') }}
                            @endif
                        </td>

                        <td>
                            @if ($user_message->read == 1)
                                <span class="badge bg-success">خوانده شده</span>
                            @elseif($user_message->read == 0)
                                <span class="badge bg-danger">خوانده نشده</span>
                            @endif
                        </td>

                        <td>
                            <div class="dropdown">
                                <button type="button" class="btn p-0 dropdown-toggle hide-arrow"
                                        data-bs-toggle="dropdown"><i class="bx bx-dots-vertical-rounded"></i></button>
                                <div class="dropdown-menu">
{{--                                    <a class="dropdown-item" href="{{ route('admin.user.edit', $user->id) }}"><i--}}
{{--                                            class="bx bx-edit-alt me-1"></i>بررسی و ویرایش</a>--}}
                                    <button type="button" class="dropdown-item" data-bs-toggle="modal" data-bs-target="#edit_message-{{$user_message->id }}">
                                        <i class="bx bx-edit-alt me-1"></i>ویرایش
                                    </button>
                                    <button class="dropdown-item"
                                            onclick="event.preventDefault();confirmDelete('delete-{{ $user_message->id }}')"><i
                                            class="bx bx-trash me-1"></i>حذف</button>
                                    <form id="delete-{{ $user->id }}"
                                          action="{{ route('admin.user.destroy.message', $user_message->id) }}" method="POST"
                                          style="display: none;">
                                        {{ csrf_field() }}
                                        {{ method_field('DELETE') }}
                                    </form>
                                </div>
                            </div>
                        </td>
                    </tr>
                @endforeach
                @foreach ($user_messages as $user_message)
                    <x-modal id="edit_message-{{$user_message->id}}" size="sm" header="ویرایش پیام ">
                        <form id="formData" action="{{ route('admin.user.update.message', $user_message->id) }}" method="post">
                            {{ csrf_field() }}
                            @method('patch')
                            <div class="tab-pane fade active show" id="tab1" role="tabpanel">
                                <div class="row g-3">
                                    <div class="col-md-12">
                                        <div class="row">
                                            <div class="col-md-12">
                                                <div class="row">
                                                    <div class="col-md-12">
                                                        <span>*</span>
                                                        <label class="form-label" for="firstname">متن پیام</label>
                                                        <textarea name="message" class="form-control" placeholder="متن پیام" required>{{ $user_message->message }}</textarea>
                                                        @if ($errors->has('message'))
                                                            <div data-field="message" class="text-danger">{{ $errors->first('message') }}
                                                            </div>
                                                        @endif
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div class="pt-4">
                                <button type="submit" name="save" class="btn btn-primary me-sm-3 me-1">ثبت</button>
                                <a href="{{ route('admin.messages', $user->id) }}" type="reset"
                                   class="btn btn-label-secondary">انصراف</a>
                            </div>
                        </form>
                    </x-modal>
                @endforeach

                </tbody>
            </table>

            <div style="margin-top: 10%;">
                {{--                {{ $educations->render() }}--}}
            </div>
        </div>
    </div>
@endsection
