<?php


Route::as('admin.')->prefix('admin')->namespace('Dashboard\Frest')->middleware('auth:admin','check_role_admin')->group(function(){
    Route::Resource('education','EducationController');
    Route::get('education/index','EducationController@index')->name('education.list');

    Route::as('bulk.')->prefix('/bulk')->group(function (){
        Route::get('/educations','EducationController@bulkAction')->name('educations');
    });
});


Route::as('admin.')->prefix('admin')->namespace('Dashboard\Frest')->middleware('auth:admin','check_role_admin')->group(function(){
    Route::Resource('major','MajorController');
    Route::get('major/index','MajorController@index')->name('major.list');

    Route::as('bulk.')->prefix('/bulk')->group(function (){
        Route::get('/majors','MajorController@bulkAction')->name('majors');
    });
});


Route::as('admin.')->prefix('admin')->namespace('Dashboard\Frest')->middleware('auth:admin','check_role_admin')->group(function(){
    Route::Resource('user','UserController');
    Route::get('user/index','UserController@index')->name('user.list');
    Route::post('user/create/note/{id}','UserController@createNote')->name('user.create.note');
    Route::get('user/messages/{id}','UserController@messages')->name('messages');
    Route::post('user/create/message/{id}','UserController@createMessage')->name('user.create.message');
    Route::patch('user/update/message/{id}','UserController@UpdateMessage')->name('user.update.message');
    Route::delete('user/destroy/message/{id}','UserController@destroyMessage')->name('user.destroy.message');

    Route::as('bulk.')->prefix('/bulk')->group(function (){
        Route::get('/users','UserController@bulkAction')->name('users');
    });
});
